/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.tls.AbstractTlsServer;
import com.aspose.cad.internal.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsCipherFactory;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsCredentials;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsFatalAlert;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsKeyExchange;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPKeyExchange;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPUtils;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsServer
extends AbstractTlsServer {
    protected TlsSRPIdentityManager srpIdentityManager;
    protected byte[] srpIdentity = null;
    protected TlsSRPLoginParameters loginParameters = null;

    public SRPTlsServer(TlsSRPIdentityManager tlsSRPIdentityManager) {
        this(new DefaultTlsCipherFactory(), tlsSRPIdentityManager);
    }

    public SRPTlsServer(TlsCipherFactory tlsCipherFactory, TlsSRPIdentityManager tlsSRPIdentityManager) {
        super(tlsCipherFactory);
        this.srpIdentityManager = tlsSRPIdentityManager;
    }

    protected TlsSignerCredentials getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49186, 49183, 49185, 49182, 49184, 49181};
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        super.processClientExtensions(hashtable);
        this.srpIdentity = TlsSRPUtils.getSRPExtension(hashtable);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        int n2 = super.getSelectedCipherSuite();
        if (TlsSRPUtils.isSRPCipherSuite(n2)) {
            if (this.srpIdentity != null) {
                this.loginParameters = this.srpIdentityManager.getLoginParameters(this.srpIdentity);
            }
            if (this.loginParameters == null) {
                throw new TlsFatalAlert(115);
            }
        }
        return n2;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 21: {
                return null;
            }
            case 22: {
                return this.getDSASignerCredentials();
            }
            case 23: {
                return this.getRSASignerCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n2) {
        return new TlsSRPKeyExchange(n2, this.supportedSignatureAlgorithms, this.srpIdentity, this.loginParameters);
    }
}

