/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.embed.InvalidStorageException;
import com.sun.star.embed.XStorage;
import com.sun.star.embed.XTransactedObject;
import com.sun.star.io.XStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lib.uno.adapter.XInputStreamToInputStreamAdapter;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;

public class StorageRepository
implements InputRepository,
OutputRepository {
    private static final Log LOGGER = LogFactory.getLog(StorageRepository.class);
    private static final String REPORT_PROCESSING_FAILED = "ReportProcessing failed";
    private XStorage input;
    private XStorage output;
    private final String rootURL;

    public StorageRepository(XStorage input, XStorage output, String rootURL) {
        this.input = input;
        this.output = output;
        this.rootURL = rootURL;
    }

    private StorageRepository(XStorage storage, boolean isOutput, String rootURL) {
        this.rootURL = rootURL;
        if (isOutput) {
            this.output = storage;
        } else {
            this.input = storage;
        }
    }

    @Override
    public InputStream createInputStream(String name) throws IOException {
        if (this.input == null) {
            throw new IOException("input is NULL");
        }
        try {
            XStream xStream = (XStream)UnoRuntime.queryInterface(XStream.class, (Object)this.input.openStreamElement(name, 1));
            return new BufferedInputStream((InputStream)new XInputStreamToInputStreamAdapter(xStream.getInputStream()), 102400);
        }
        catch (Exception ex1) {
            IOException ex2 = new IOException();
            ex2.initCause(ex1);
            throw ex2;
        }
    }

    @Override
    public OutputStream createOutputStream(String name, String mimeType) throws IOException {
        if (this.output == null) {
            throw new IOException("output is NULL");
        }
        try {
            XStream stream = this.output.openStreamElement(name, 12);
            stream.getInputStream().closeInput();
            if (mimeType != null) {
                XPropertySet prop = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)stream);
                prop.setPropertyValue("MediaType", (Object)mimeType);
            }
            return new BufferedOutputStream((OutputStream)new XOutputStreamToOutputStreamAdapter(stream.getOutputStream()), 204800);
        }
        catch (Exception ex1) {
            IOException ex2 = new IOException();
            ex2.initCause(ex1);
            throw ex2;
        }
    }

    @Override
    public boolean exists(String name) {
        try {
            return this.output.isStreamElement(name);
        }
        catch (InvalidStorageException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object getId() {
        return "1";
    }

    @Override
    public long getVersion(String name) {
        return 1L;
    }

    @Override
    public boolean isReadable(String name) {
        try {
            if (this.input != null) {
                return this.input.isStreamElement(name);
            }
        }
        catch (InvalidStorageException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (NoSuchElementException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        return false;
    }

    @Override
    public InputRepository openInputRepository(String name) throws IOException {
        try {
            String temp = this.shortenName(name);
            if (!this.input.isStorageElement(temp)) {
                throw new IOException();
            }
            XStorage storage = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)this.input.openStorageElement(temp, 1));
            return new StorageRepository(storage, false, this.rootURL);
        }
        catch (NoSuchElementException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (WrappedTargetException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (InvalidStorageException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (com.sun.star.io.IOException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        throw new IOException();
    }

    private final String shortenName(String name) {
        String temp = name.startsWith("./") ? name.substring(2) : name;
        return temp;
    }

    @Override
    public OutputRepository openOutputRepository(String name, String mimeType) throws IOException {
        try {
            String temp = this.shortenName(name);
            XStorage storage = (XStorage)UnoRuntime.queryInterface(XStorage.class, (Object)this.output.openStorageElement(temp, 4));
            if (mimeType != null) {
                XPropertySet prop = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)storage);
                prop.setPropertyValue("MediaType", (Object)mimeType);
            }
            return new StorageRepository(storage, true, this.rootURL);
        }
        catch (UnknownPropertyException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (PropertyVetoException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (WrappedTargetException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (InvalidStorageException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (com.sun.star.io.IOException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        throw new IOException();
    }

    @Override
    public void closeInputRepository() {
        if (this.input != null) {
            this.input.dispose();
        }
    }

    @Override
    public void closeOutputRepository() {
        if (this.output != null) {
            try {
                XTransactedObject obj = (XTransactedObject)UnoRuntime.queryInterface(XTransactedObject.class, (Object)this.output);
                if (obj != null) {
                    obj.commit();
                }
            }
            catch (com.sun.star.io.IOException ex) {
                LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
            }
            catch (WrappedTargetException ex) {
                LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
            }
            this.output.dispose();
        }
    }

    @Override
    public boolean existsStorage(String name) {
        try {
            return this.output.isStorageElement(name);
        }
        catch (InvalidStorageException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error((Object)REPORT_PROCESSING_FAILED, (Throwable)ex);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getRootURL() {
        return this.rootURL;
    }
}

