/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileContentLocation;

public class TempFileNameGenerator
implements NameGenerator {
    private FileContentLocation fileContentLocation;

    public TempFileNameGenerator(FileContentLocation fileContentLocation) {
        if (fileContentLocation == null) {
            throw new NullPointerException();
        }
        this.fileContentLocation = fileContentLocation;
    }

    @Override
    public String generateName(String nameHint, String mimeType) throws ContentIOException {
        MimeRegistry mimeRegistry = this.fileContentLocation.getRepository().getMimeRegistry();
        File targetDirectory = this.fileContentLocation.getBackend();
        String suffix = mimeRegistry.getSuffix(mimeType);
        try {
            File tempFile = File.createTempFile(nameHint, "." + suffix, targetDirectory);
            return tempFile.getName();
        }
        catch (IOException e) {
            throw new ContentIOException("Unable to generate a name for the data file", e);
        }
    }
}

