/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import org.openoffice.xmerge.ConverterCapabilities;
import org.openoffice.xmerge.merger.diff.NodeIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CellNodeIterator
extends NodeIterator {
    private static final String SUPPORTED_TAG1 = "table:table-cell";

    public CellNodeIterator(ConverterCapabilities cc, Node node) {
        super(cc, node);
    }

    @Override
    protected boolean nodeSupported(Node node) {
        return node.getNodeType() == 1 && node.getNodeName().equals(SUPPORTED_TAG1);
    }

    @Override
    protected boolean childrenEqual(Node node1, Node node2) {
        boolean equal = false;
        if (node1.hasChildNodes() && node2.hasChildNodes()) {
            Element cell1 = (Element)node1;
            Element cell2 = (Element)node2;
            Node paraNode1 = cell1.getElementsByTagName("text:p").item(0);
            Node paraNode2 = cell2.getElementsByTagName("text:p").item(0);
            equal = super.compareNode(paraNode1, paraNode2);
        }
        return equal;
    }
}

