/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder.layout;

import com.sun.star.awt.Rectangle;
import com.sun.star.report.XSection;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.reportbuilder.layout.ReportBuilderLayouter;
import com.sun.star.wizards.reportbuilder.layout.SectionObject;

public class ColumnarTwoColumns
extends ReportBuilderLayouter {
    public ColumnarTwoColumns(IReportDefinitionReadAccess _xDefinitionAccess, Resource _aResource) {
        super(_xDefinitionAccess, _aResource);
    }

    public String getName() {
        return "ColumnarTwoColumnsLayoutOfData";
    }

    public String getLocalizedName() {
        return this.getResource().getResText("RID_REPORT_82");
    }

    @Override
    protected void insertDetailFields() {
        this.insertDetailFields(2);
    }

    protected void insertDetailFields(int _nColumns) {
        int nWidth;
        this.copyDetailProperties();
        if (_nColumns < 1) {
            return;
        }
        String[] aFieldTitleNames = this.getFieldTitleNames();
        if (aFieldTitleNames == null) {
            return;
        }
        String[] aFieldNames = this.getFieldNames();
        if (aFieldNames == null) {
            return;
        }
        XSection xSection = this.getReportDefinition().getDetail();
        Rectangle aRect = new Rectangle();
        int nLabelWidth = this.getMaxLabelWidth();
        int nUsablePageWidth = this.getPageWidth() - this.getLeftPageIndent() - this.getRightPageIndent() - this.getLeftGroupIndent(this.getCountOfGroups());
        int i = 0;
        int nRows = aFieldNames.length / _nColumns;
        if (aFieldNames.length % _nColumns != 0) {
            ++nRows;
        }
        if ((nWidth = (nUsablePageWidth - nLabelWidth * _nColumns) / _nColumns) < 0) {
            return;
        }
        SectionObject aSOLabel = this.getDesignTemplate().getDetailLabel();
        aSOLabel.setFontToBold();
        SectionObject aSOTextField = this.getDesignTemplate().getDetailTextField();
        int nMaxHeight = 0;
        for (int x = 0; x < _nColumns; ++x) {
            aRect.Y = 0;
            for (int y = 0; y < nRows; ++y) {
                aRect.X = this.getLeftPageIndent() + this.getLeftGroupIndent(this.getCountOfGroups()) + x * (nWidth + nLabelWidth);
                if (i >= aFieldNames.length) continue;
                String sLabel = aFieldTitleNames[i];
                aRect = this.insertLabel(xSection, sLabel, aRect, nLabelWidth, aSOLabel);
                String sFieldName = this.convertToFieldName(aFieldNames[i]);
                aRect = this.insertFormattedField(xSection, sFieldName, aRect, nWidth, aSOTextField);
                aRect.Y += Math.max(aSOLabel.getHeight(500), aRect.Height);
                ++i;
            }
            nMaxHeight = Math.max(aRect.Y, nMaxHeight);
        }
        aRect.Y = Math.max(aSOLabel.getHeight(500) * nRows, nMaxHeight);
        aRect.Y += aSOLabel.getHeight(500);
        xSection.setHeight(aRect.Y);
        this.doNotBreakInTable(xSection);
    }

    @Override
    protected void insertDetailFieldTitles(int lastGroupPosition) {
    }
}

