/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.data;

import org.jfree.report.DataFlags;
import org.jfree.report.DataRow;
import org.jfree.report.DataSourceException;
import org.jfree.report.data.DefaultDataFlags;
import org.jfree.report.util.LazyNameMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class GlobalView
implements DataRow {
    private DataFlags[] oldData;
    private LazyNameMap oldCache;
    private DataFlags[] data;
    private LazyNameMap nameCache;
    private int length;

    private GlobalView() {
    }

    public static GlobalView createView() {
        GlobalView globalView = new GlobalView();
        globalView.nameCache = new LazyNameMap();
        globalView.oldCache = new LazyNameMap();
        globalView.data = new DataFlags[10];
        globalView.oldData = new DataFlags[0];
        return globalView;
    }

    private void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n2 > n) {
            return;
        }
        int n3 = Math.max(n2 * 2, n + 10);
        DataFlags[] dataFlagsArray = new DataFlags[n3];
        System.arraycopy(this.data, 0, dataFlagsArray, 0, this.length);
        this.data = dataFlagsArray;
    }

    public synchronized void putField(String string, Object object, boolean bl) throws DataSourceException {
        if (string == null) {
            throw new NullPointerException("Name must not be null.");
        }
        LazyNameMap.NameCarrier nameCarrier = this.nameCache.get(string);
        DefaultDataFlags defaultDataFlags = new DefaultDataFlags(string, object, this.computeChange(string, object));
        if (nameCarrier != null) {
            this.data[nameCarrier.getValue()] = defaultDataFlags;
            if (!bl) {
                nameCarrier.increase();
            }
            return;
        }
        for (int i = 0; i < this.length; ++i) {
            DataFlags dataFlags = this.data[i];
            if (dataFlags != null) continue;
            this.data[i] = defaultDataFlags;
            this.nameCache.setValue(string, i);
            return;
        }
        this.ensureCapacity(this.length + 1);
        this.data[this.length] = defaultDataFlags;
        this.nameCache.setValue(string, this.length);
        ++this.length;
    }

    private boolean computeChange(String string, Object object) throws DataSourceException {
        LazyNameMap.NameCarrier nameCarrier = this.oldCache.get(string);
        if (nameCarrier == null) {
            return true;
        }
        DataFlags dataFlags = this.oldData[nameCarrier.getValue()];
        if (dataFlags == null) {
            return true;
        }
        return !ObjectUtilities.equal((Object)dataFlags.getValue(), (Object)object);
    }

    @Override
    public Object get(int n) throws DataSourceException {
        DataFlags dataFlags = this.getFlags(n);
        if (dataFlags == null) {
            return null;
        }
        return dataFlags.getValue();
    }

    @Override
    public Object get(String string) throws DataSourceException {
        DataFlags dataFlags = this.getFlags(string);
        if (dataFlags == null) {
            return null;
        }
        return dataFlags.getValue();
    }

    @Override
    public String getColumnName(int n) {
        DataFlags dataFlags = this.getFlags(n);
        if (dataFlags == null) {
            return null;
        }
        return dataFlags.getName();
    }

    @Override
    public int getColumnCount() {
        return this.length;
    }

    @Override
    public DataFlags getFlags(String string) {
        int n;
        DataFlags dataFlags;
        LazyNameMap.NameCarrier nameCarrier = this.nameCache.get(string);
        if (nameCarrier != null && (dataFlags = this.data[n = nameCarrier.getValue()]) != null) {
            return dataFlags;
        }
        LazyNameMap.NameCarrier nameCarrier2 = this.oldCache.get(string);
        if (nameCarrier2 == null) {
            return null;
        }
        int n2 = nameCarrier2.getValue();
        if (n2 < this.oldData.length) {
            return this.oldData[n2];
        }
        return null;
    }

    @Override
    public DataFlags getFlags(int n) {
        DataFlags dataFlags = this.data[n];
        if (dataFlags != null) {
            return dataFlags;
        }
        return this.oldData[n];
    }

    public GlobalView derive() {
        GlobalView globalView = new GlobalView();
        globalView.oldCache = (LazyNameMap)this.oldCache.clone();
        globalView.data = (DataFlags[])this.data.clone();
        globalView.oldData = (DataFlags[])this.oldData.clone();
        globalView.length = this.length;
        globalView.nameCache = (LazyNameMap)this.nameCache.clone();
        return globalView;
    }

    public GlobalView advance() {
        GlobalView globalView = new GlobalView();
        globalView.oldCache = (LazyNameMap)this.nameCache.clone();
        globalView.oldData = (DataFlags[])this.data.clone();
        globalView.data = new DataFlags[globalView.oldData.length];
        globalView.length = this.length;
        globalView.nameCache = new LazyNameMap();
        return globalView;
    }

    public synchronized void removeColumn(String string) {
        LazyNameMap.NameCarrier nameCarrier = this.nameCache.get(string);
        if (nameCarrier == null) {
            return;
        }
        nameCarrier.decrease();
        if (nameCarrier.getInstanceCount() < 1) {
            this.nameCache.remove(string);
            this.data[nameCarrier.getValue()] = null;
        }
    }
}

