/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.awt;

import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontType;

public class AWTFontRecord
implements FontRecord,
FontIdentifier {
    private FontFamily fontFamily;
    private boolean bold;
    private boolean italics;

    public AWTFontRecord(FontFamily fontFamily, boolean bold, boolean italics) {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.fontFamily = fontFamily;
        this.bold = bold;
        this.italics = italics;
    }

    @Override
    public FontFamily getFamily() {
        return this.fontFamily;
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    @Override
    public boolean isItalic() {
        return this.italics;
    }

    @Override
    public boolean isOblique() {
        return this.italics;
    }

    @Override
    public FontIdentifier getIdentifier() {
        return this;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public FontType getFontType() {
        return FontType.AWT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWTFontRecord that = (AWTFontRecord)o;
        if (this.bold != that.bold) {
            return false;
        }
        if (this.italics != that.italics) {
            return false;
        }
        return this.fontFamily.equals(that.fontFamily);
    }

    @Override
    public int hashCode() {
        int result = this.fontFamily.hashCode();
        result = 29 * result + (this.bold ? 1 : 0);
        result = 29 * result + (this.italics ? 1 : 0);
        return result;
    }
}

