/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import com.sun.star.sdbcx.comp.hsqldb.NativeInputStreamHelper;
import com.sun.star.sdbcx.comp.hsqldb.NativeLibraries;
import com.sun.star.sdbcx.comp.hsqldb.NativeOutputStreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileSystemRuntimeException;

public class StorageFileAccess
implements FileAccess {
    String ds_name;
    String key;

    public StorageFileAccess(Object key) throws Exception {
        this.key = (String)key;
    }

    public void createParentDirs(String filename) {
    }

    public boolean isStreamElement(String elementName) {
        return StorageFileAccess.isStreamElement(this.key, elementName);
    }

    public InputStream openInputStreamElement(String streamName) throws IOException {
        return new NativeInputStreamHelper(this.key, streamName);
    }

    public OutputStream openOutputStreamElement(String streamName) throws IOException {
        return new NativeOutputStreamHelper(this.key, streamName);
    }

    public void removeElement(String filename) throws NoSuchElementException {
        try {
            if (StorageFileAccess.isStreamElement(this.key, filename)) {
                StorageFileAccess.removeElement(this.key, filename);
            }
        }
        catch (IOException e) {
            throw new FileSystemRuntimeException(e);
        }
    }

    public void renameElement(String oldName, String newName) throws NoSuchElementException {
        try {
            if (StorageFileAccess.isStreamElement(this.key, oldName)) {
                StorageFileAccess.removeElement(this.key, newName);
                StorageFileAccess.renameElement(this.key, oldName, newName);
            }
        }
        catch (IOException e) {
            throw new FileSystemRuntimeException(e);
        }
    }

    public FileAccess.FileSync getFileSync(OutputStream os) throws IOException {
        return new FileSync((NativeOutputStreamHelper)os);
    }

    static native boolean isStreamElement(String var0, String var1);

    static native void removeElement(String var0, String var1) throws NoSuchElementException, IOException;

    static native void renameElement(String var0, String var1, String var2) throws NoSuchElementException, IOException;

    static {
        NativeLibraries.load();
    }

    private static class FileSync
    implements FileAccess.FileSync {
        private final NativeOutputStreamHelper os;

        private FileSync(NativeOutputStreamHelper _os) {
            this.os = _os;
        }

        public void sync() throws IOException {
            this.os.sync();
        }
    }
}

