/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jce.provider;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1String;
import com.aspose.cad.internal.bouncycastle.asn1.DERBitString;
import com.aspose.cad.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.cad.internal.bouncycastle.asn1.DERNull;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.misc.NetscapeCertType;
import com.aspose.cad.internal.bouncycastle.asn1.misc.NetscapeRevocationURL;
import com.aspose.cad.internal.bouncycastle.asn1.misc.VerisignCzagExtension;
import com.aspose.cad.internal.bouncycastle.asn1.util.ASN1Dump;
import com.aspose.cad.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.cad.internal.bouncycastle.asn1.x500.style.RFC4519Style;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.BasicConstraints;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import com.aspose.cad.internal.bouncycastle.asn1.x509.KeyUsage;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.aspose.cad.internal.bouncycastle.jce.X509Principal;
import com.aspose.cad.internal.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.aspose.cad.internal.bouncycastle.jce.provider.BouncyCastleProvider;
import com.aspose.cad.internal.bouncycastle.jce.provider.i;
import com.aspose.cad.internal.bouncycastle.jce.provider.l;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Integers;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import com.aspose.cad.internal.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CertificateObject
extends X509Certificate
implements PKCS12BagAttributeCarrier {
    private com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate a;
    private BasicConstraints b;
    private boolean[] c;
    private boolean d;
    private int e;
    private PKCS12BagAttributeCarrier f = new PKCS12BagAttributeCarrierImpl();

    public X509CertificateObject(com.aspose.cad.internal.bouncycastle.asn1.x509.Certificate certificate) throws CertificateParsingException {
        byte[] byArray;
        this.a = certificate;
        try {
            byArray = this.a("2.5.29.19");
            if (byArray != null) {
                this.b = BasicConstraints.getInstance(ASN1Primitive.fromByteArray(byArray));
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct BasicConstraints: " + exception);
        }
        try {
            byArray = this.a("2.5.29.15");
            if (byArray != null) {
                DERBitString dERBitString = DERBitString.getInstance(ASN1Primitive.fromByteArray(byArray));
                int n2 = (byArray = dERBitString.getBytes()).length * 8 - dERBitString.getPadBits();
                this.c = new boolean[n2 < 9 ? 9 : n2];
                for (int i2 = 0; i2 != n2; ++i2) {
                    this.c[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
                }
            } else {
                this.c = null;
            }
        }
        catch (Exception exception) {
            throw new CertificateParsingException("cannot construct KeyUsage: " + exception);
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.a.getEndDate().getTime());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.a.getStartDate().getTime());
        }
    }

    @Override
    public int getVersion() {
        return this.a.getVersionNumber();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a.getSerialNumber().getValue();
    }

    @Override
    public Principal getIssuerDN() {
        try {
            return new X509Principal(X500Name.getInstance(this.a.getIssuer().getEncoded()));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.a.getIssuer());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        return new X509Principal(X500Name.getInstance(this.a.getSubject().toASN1Primitive()));
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(this.a.getSubject());
            return new X500Principal(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getNotBefore() {
        return this.a.getStartDate().getDate();
    }

    @Override
    public Date getNotAfter() {
        return this.a.getEndDate().getDate();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.a.getTBSCertificate().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.a.getSignature().getOctets();
    }

    @Override
    public String getSigAlgName() {
        Object object;
        Provider provider = Security.getProvider("BC");
        if (provider != null && (object = provider.getProperty("Alg.Alias.Signature." + this.getSigAlgOID())) != null) {
            return object;
        }
        object = Security.getProviders();
        for (int i2 = 0; i2 != ((Provider[])object).length; ++i2) {
            String string = object[i2].getProperty("Alg.Alias.Signature." + this.getSigAlgOID());
            if (string == null) continue;
            return string;
        }
        return this.getSigAlgOID();
    }

    @Override
    public String getSigAlgOID() {
        return this.a.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.a.getSignatureAlgorithm().getParameters() != null) {
            try {
                return this.a.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER");
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        DERBitString dERBitString = this.a.getTBSCertificate().getIssuerUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        DERBitString dERBitString = this.a.getTBSCertificate().getSubjectUniqueId();
        if (dERBitString != null) {
            byte[] byArray = dERBitString.getBytes();
            boolean[] blArray = new boolean[byArray.length * 8 - dERBitString.getPadBits()];
            for (int i2 = 0; i2 != blArray.length; ++i2) {
                blArray[i2] = (byArray[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.c;
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = this.a("2.5.29.37");
        if (byArray != null) {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
                    arrayList.add(((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(i2)).getId());
                }
                return Collections.unmodifiableList(arrayList);
            }
            catch (Exception exception) {
                throw new CertificateParsingException("error processing extended key usage extension");
            }
        }
        return null;
    }

    @Override
    public int getBasicConstraints() {
        if (this.b != null) {
            if (this.b.isCA()) {
                if (this.b.getPathLenConstraint() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.b.getPathLenConstraint().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return X509CertificateObject.a(this.a(Extension.subjectAlternativeName.getId()));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return X509CertificateObject.a(this.a(Extension.issuerAlternativeName.getId()));
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            Extensions extensions = this.a.getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration enumeration = extensions.oids();
                while (enumeration.hasMoreElements()) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                    Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                    if (!extension.isCritical()) continue;
                    hashSet.add(aSN1ObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    private byte[] a(String string) {
        Extension extension;
        Extensions extensions = this.a.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(new ASN1ObjectIdentifier(string))) != null) {
            return extension.getExtnValue().getOctets();
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        Extension extension;
        Extensions extensions = this.a.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(new ASN1ObjectIdentifier(string))) != null) {
            try {
                return extension.getExtnValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            Extensions extensions = this.a.getTBSCertificate().getExtensions();
            if (extensions != null) {
                Enumeration enumeration = extensions.oids();
                while (enumeration.hasMoreElements()) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                    Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                    if (extension.isCritical()) continue;
                    hashSet.add(aSN1ObjectIdentifier.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Extensions extensions;
        if (this.getVersion() == 3 && (extensions = this.a.getTBSCertificate().getExtensions()) != null) {
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                Extension extension;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                String string = aSN1ObjectIdentifier.getId();
                if (string.equals(i.m) || string.equals(i.a) || string.equals(i.b) || string.equals(i.c) || string.equals(i.i) || string.equals(i.d) || string.equals(i.f) || string.equals(i.g) || string.equals(i.h) || string.equals(i.j) || string.equals(i.k) || !(extension = extensions.getExtension(aSN1ObjectIdentifier)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return BouncyCastleProvider.getPublicKey(this.a.getSubjectPublicKeyInfo());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.a.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Certificate)) {
            return false;
        }
        Certificate certificate = (Certificate)object;
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = certificate.getEncoded();
            return Arrays.areEqual(byArray, byArray2);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    @Override
    public synchronized int hashCode() {
        if (!this.d) {
            this.e = this.a();
            this.d = true;
        }
        return this.e;
    }

    private int a() {
        try {
            int n2 = 0;
            byte[] byArray = this.getEncoded();
            for (int i2 = 1; i2 < byArray.length; ++i2) {
                n2 += byArray[i2] * i2;
            }
            return n2;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.f.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.f.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.f.getBagAttributeKeys();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(Hex.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(Hex.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(Hex.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        Extensions extensions = this.a.getTBSCertificate().getExtensions();
        if (extensions != null) {
            Enumeration enumeration = extensions.oids();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (extension.getExtnValue() != null) {
                    byte[] byArray2 = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray2);
                    stringBuffer.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        if (aSN1ObjectIdentifier.equals(Extension.basicConstraints)) {
                            stringBuffer.append(BasicConstraints.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals(Extension.keyUsage)) {
                            stringBuffer.append(KeyUsage.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals(MiscObjectIdentifiers.netscapeCertType)) {
                            stringBuffer.append(new NetscapeCertType((DERBitString)aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals(MiscObjectIdentifiers.netscapeRevocationURL)) {
                            stringBuffer.append(new NetscapeRevocationURL((DERIA5String)aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (aSN1ObjectIdentifier.equals(MiscObjectIdentifiers.verisignCzagExtension)) {
                            stringBuffer.append(new VerisignCzagExtension((DERIA5String)aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        stringBuffer.append(aSN1ObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream.readObject())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(aSN1ObjectIdentifier.getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = l.a(this.a.getSignatureAlgorithm());
        try {
            signature = Signature.getInstance(string, "BC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.a(publicKey, signature);
    }

    @Override
    public final void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string2 = l.a(this.a.getSignatureAlgorithm());
        Signature signature = string != null ? Signature.getInstance(string2, string) : Signature.getInstance(string2);
        this.a(publicKey, signature);
    }

    @Override
    public final void verify(PublicKey publicKey, Provider provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        String string = l.a(this.a.getSignatureAlgorithm());
        Signature signature = provider != null ? Signature.getInstance(string, provider) : Signature.getInstance(string);
        this.a(publicKey, signature);
    }

    private void a(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.a(this.a.getSignatureAlgorithm(), this.a.getTBSCertificate().getSignature())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        ASN1Encodable aSN1Encodable = this.a.getSignatureAlgorithm().getParameters();
        l.a(signature, aSN1Encodable);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertificate());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private boolean a(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        if (!algorithmIdentifier.getAlgorithm().equals(algorithmIdentifier2.getAlgorithm())) {
            return false;
        }
        if (algorithmIdentifier.getParameters() == null) {
            return algorithmIdentifier2.getParameters() == null || algorithmIdentifier2.getParameters().equals(DERNull.INSTANCE);
        }
        if (algorithmIdentifier2.getParameters() == null) {
            return algorithmIdentifier.getParameters() == null || algorithmIdentifier.getParameters().equals(DERNull.INSTANCE);
        }
        return algorithmIdentifier.getParameters().equals(algorithmIdentifier2.getParameters());
    }

    private static Collection a(byte[] byArray) throws CertificateParsingException {
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = ASN1Sequence.getInstance(byArray).getObjects();
            block11: while (enumeration.hasMoreElements()) {
                GeneralName generalName = GeneralName.getInstance(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(Integers.valueOf(generalName.getTagNo()));
                switch (generalName.getTagNo()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(generalName.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(X500Name.getInstance(RFC4519Style.INSTANCE, generalName.getName()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((ASN1String)((Object)generalName.getName())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(ASN1ObjectIdentifier.getInstance(generalName.getName()).getId());
                        break;
                    }
                    case 7: {
                        String string;
                        byte[] byArray2 = DEROctetString.getInstance(generalName.getName()).getOctets();
                        try {
                            string = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + generalName.getTagNo());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }
}

