/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.signers;

import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.signers.DSAKCalculator;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class HMacDSAKCalculator
implements DSAKCalculator {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private final HMac b;
    private final byte[] c;
    private final byte[] d;
    private BigInteger e;

    public HMacDSAKCalculator(Digest digest) {
        this.b = new HMac(digest);
        this.d = new byte[this.b.getMacSize()];
        this.c = new byte[this.b.getMacSize()];
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public void init(BigInteger bigInteger, SecureRandom secureRandom) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void init(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        this.e = bigInteger;
        Arrays.fill(this.d, (byte)1);
        Arrays.fill(this.c, (byte)0);
        byte[] byArray2 = new byte[(bigInteger.bitLength() + 7) / 8];
        byte[] byArray3 = BigIntegers.asUnsignedByteArray(bigInteger2);
        System.arraycopy(byArray3, 0, byArray2, byArray2.length - byArray3.length, byArray3.length);
        byte[] byArray4 = new byte[(bigInteger.bitLength() + 7) / 8];
        BigInteger bigInteger3 = this.a(byArray);
        if (bigInteger3.compareTo(bigInteger) >= 0) {
            bigInteger3 = bigInteger3.subtract(bigInteger);
        }
        byte[] byArray5 = BigIntegers.asUnsignedByteArray(bigInteger3);
        System.arraycopy(byArray5, 0, byArray4, byArray4.length - byArray5.length, byArray5.length);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.update((byte)0);
        this.b.update(byArray2, 0, byArray2.length);
        this.b.update(byArray4, 0, byArray4.length);
        this.b.doFinal(this.c, 0);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.doFinal(this.d, 0);
        this.b.update(this.d, 0, this.d.length);
        this.b.update((byte)1);
        this.b.update(byArray2, 0, byArray2.length);
        this.b.update(byArray4, 0, byArray4.length);
        this.b.doFinal(this.c, 0);
        this.b.init(new KeyParameter(this.c));
        this.b.update(this.d, 0, this.d.length);
        this.b.doFinal(this.d, 0);
    }

    @Override
    public BigInteger nextK() {
        byte[] byArray = new byte[(this.e.bitLength() + 7) / 8];
        while (true) {
            int n2;
            for (int i2 = 0; i2 < byArray.length; i2 += n2) {
                this.b.update(this.d, 0, this.d.length);
                this.b.doFinal(this.d, 0);
                n2 = Math.min(byArray.length - i2, this.d.length);
                System.arraycopy(this.d, 0, byArray, i2, n2);
            }
            BigInteger bigInteger = this.a(byArray);
            if (bigInteger.compareTo(a) > 0 && bigInteger.compareTo(this.e) < 0) {
                return bigInteger;
            }
            this.b.update(this.d, 0, this.d.length);
            this.b.update((byte)0);
            this.b.doFinal(this.c, 0);
            this.b.init(new KeyParameter(this.c));
            this.b.update(this.d, 0, this.d.length);
            this.b.doFinal(this.d, 0);
        }
    }

    private BigInteger a(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (byArray.length * 8 > this.e.bitLength()) {
            bigInteger = bigInteger.shiftRight(byArray.length * 8 - this.e.bitLength());
        }
        return bigInteger;
    }
}

