/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.signers;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DSA;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.cad.internal.bouncycastle.math.ec.ECConstants;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSA {
    private boolean a;
    private ECKeyParameters b;
    private SecureRandom c;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.a = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.c = parametersWithRandom.getRandom();
                this.b = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.c = new SecureRandom();
                this.b = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.b = (ECPublicKeyParameters)cipherParameters;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        Object object;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair;
        Object object2;
        BigInteger[] bigIntegerArray;
        if (!this.a) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger bigInteger = ((ECPrivateKeyParameters)this.b).getParameters().getN();
        int n2 = bigInteger.bitLength();
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        int n3 = bigInteger2.bitLength();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.b;
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        do {
            object = new ECKeyPairGenerator();
            ((ECKeyPairGenerator)object).init(new ECKeyGenerationParameters(eCPrivateKeyParameters.getParameters(), this.c));
        } while ((bigInteger3 = (bigIntegerArray = ((ECPublicKeyParameters)(object2 = (ECPublicKeyParameters)(asymmetricCipherKeyPair = ((ECKeyPairGenerator)object).generateKeyPair()).getPublic())).getQ().getAffineXCoord().toBigInteger()).add(bigInteger2).mod(bigInteger)).equals(ECConstants.ZERO));
        object = eCPrivateKeyParameters.getD();
        object2 = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        bigInteger4 = ((BigInteger)object2).subtract(bigInteger3.multiply((BigInteger)object)).mod(bigInteger);
        bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (this.a) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.b;
        BigInteger bigInteger3 = eCPublicKeyParameters.getParameters().getN();
        int n2 = bigInteger3.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        int n3 = bigInteger4.bitLength();
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ZERO) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECPoint eCPoint2 = eCPublicKeyParameters.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger2, eCPoint = eCPublicKeyParameters.getQ(), bigInteger).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger5 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger6 = bigInteger.subtract(bigInteger5).mod(bigInteger3);
        return bigInteger6.equals(bigInteger4);
    }
}

