/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.prng;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;

public class FixedSecureRandom
extends SecureRandom {
    private byte[] a;
    private int b;
    private int c;

    public FixedSecureRandom(byte[] byArray) {
        this(false, new byte[][]{byArray});
    }

    public FixedSecureRandom(byte[][] byArray) {
        this(false, byArray);
    }

    public FixedSecureRandom(boolean bl2, byte[] byArray) {
        this(bl2, new byte[][]{byArray});
    }

    public FixedSecureRandom(boolean bl2, byte[][] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            try {
                byteArrayOutputStream.write(byArray[i2]);
                continue;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't save value array.");
            }
        }
        this.a = byteArrayOutputStream.toByteArray();
        if (bl2) {
            this.c = this.a.length % 4;
        }
    }

    @Override
    public void nextBytes(byte[] byArray) {
        System.arraycopy(this.a, this.b, byArray, 0, byArray.length);
        this.b += byArray.length;
    }

    @Override
    public byte[] generateSeed(int n2) {
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        return byArray;
    }

    @Override
    public int nextInt() {
        int n2 = 0;
        n2 |= this.a() << 24;
        n2 |= this.a() << 16;
        if (this.c == 2) {
            --this.c;
        } else {
            n2 |= this.a() << 8;
        }
        if (this.c == 1) {
            --this.c;
        } else {
            n2 |= this.a();
        }
        return n2;
    }

    @Override
    public long nextLong() {
        long l2 = 0L;
        l2 |= (long)this.a() << 56;
        l2 |= (long)this.a() << 48;
        l2 |= (long)this.a() << 40;
        l2 |= (long)this.a() << 32;
        l2 |= (long)this.a() << 24;
        l2 |= (long)this.a() << 16;
        l2 |= (long)this.a() << 8;
        return l2 |= (long)this.a();
    }

    public boolean isExhausted() {
        return this.b == this.a.length;
    }

    private int a() {
        return this.a[this.b++] & 0xFF;
    }
}

