/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.Wrapper;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher a;
    private boolean b;
    private KeyParameter c;
    private boolean d;
    private byte[] e = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher blockCipher) {
        this(blockCipher, false);
    }

    public RFC3394WrapEngine(BlockCipher blockCipher, boolean bl2) {
        this.a = blockCipher;
        this.b = !bl2;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.d = bl2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            this.c = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.e = ((ParametersWithIV)cipherParameters).getIV();
            this.c = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (this.e.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName();
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.d) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n4 = n3 / 8;
        if (n4 * 8 != n3) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n3 + this.e.length];
        byte[] byArray3 = new byte[8 + this.e.length];
        System.arraycopy(this.e, 0, byArray2, 0, this.e.length);
        System.arraycopy(byArray, n2, byArray2, this.e.length, n3);
        this.a.init(this.b, this.c);
        for (int i2 = 0; i2 != 6; ++i2) {
            for (int i3 = 1; i3 <= n4; ++i3) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.e.length);
                System.arraycopy(byArray2, 8 * i3, byArray3, this.e.length, 8);
                this.a.processBlock(byArray3, 0, byArray3, 0);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by2 = (byte)n5;
                    int n7 = this.e.length - n6;
                    byArray3[n7] = (byte)(byArray3[n7] ^ by2);
                    n5 >>>= 8;
                    ++n6;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray2, 8 * i3, 8);
            }
        }
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.d) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = n3 / 8;
        if (n4 * 8 != n3) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n3 - this.e.length];
        byte[] byArray3 = new byte[this.e.length];
        byte[] byArray4 = new byte[8 + this.e.length];
        System.arraycopy(byArray, n2, byArray3, 0, this.e.length);
        System.arraycopy(byArray, n2 + this.e.length, byArray2, 0, n3 - this.e.length);
        this.a.init(!this.b, this.c);
        --n4;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n4; i3 >= 1; --i3) {
                System.arraycopy(byArray3, 0, byArray4, 0, this.e.length);
                System.arraycopy(byArray2, 8 * (i3 - 1), byArray4, this.e.length, 8);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by2 = (byte)n5;
                    int n7 = this.e.length - n6;
                    byArray4[n7] = (byte)(byArray4[n7] ^ by2);
                    n5 >>>= 8;
                    ++n6;
                }
                this.a.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, 8 * (i3 - 1), 8);
            }
        }
        if (!Arrays.constantTimeAreEqual(byArray3, this.e)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray2;
    }
}

