/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.engines;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.engines.DESEngine;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] a = null;
    private int[] b = null;
    private int[] c = null;
    private boolean d;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + cipherParameters.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)cipherParameters).getKey();
        if (byArray.length != 24 && byArray.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.d = bl2;
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        this.a = this.generateWorkingKey(bl2, byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
        this.b = this.generateWorkingKey(!bl2, byArray3);
        if (byArray.length == 24) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 16, byArray4, 0, byArray4.length);
            this.c = this.generateWorkingKey(bl2, byArray4);
        } else {
            this.c = this.a;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.a == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (n2 + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n3 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray3 = new byte[8];
        if (this.d) {
            this.desFunc(this.a, byArray, n2, byArray3, 0);
            this.desFunc(this.b, byArray3, 0, byArray3, 0);
            this.desFunc(this.c, byArray3, 0, byArray2, n3);
        } else {
            this.desFunc(this.c, byArray, n2, byArray3, 0);
            this.desFunc(this.b, byArray3, 0, byArray3, 0);
            this.desFunc(this.a, byArray3, 0, byArray2, n3);
        }
        return 8;
    }

    @Override
    public void reset() {
    }
}

