/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.digests;

import com.aspose.cad.internal.bouncycastle.crypto.ExtendedDigest;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SkeinEngine;
import com.aspose.cad.internal.bouncycastle.crypto.params.SkeinParameters;
import com.aspose.cad.internal.bouncycastle.util.Memoable;

public class SkeinDigest
implements ExtendedDigest,
Memoable {
    public static final int SKEIN_256 = 256;
    public static final int SKEIN_512 = 512;
    public static final int SKEIN_1024 = 1024;
    private SkeinEngine a;

    public SkeinDigest(int n2, int n3) {
        this.a = new SkeinEngine(n2, n3);
        this.init(null);
    }

    public SkeinDigest(SkeinDigest skeinDigest) {
        this.a = new SkeinEngine(skeinDigest.a);
    }

    @Override
    public void reset(Memoable memoable) {
        SkeinDigest skeinDigest = (SkeinDigest)memoable;
        this.a.reset(skeinDigest.a);
    }

    @Override
    public Memoable copy() {
        return new SkeinDigest(this);
    }

    @Override
    public String getAlgorithmName() {
        return "Skein-" + this.a.getBlockSize() * 8 + "-" + this.a.getOutputSize() * 8;
    }

    @Override
    public int getDigestSize() {
        return this.a.getOutputSize();
    }

    @Override
    public int getByteLength() {
        return this.a.getBlockSize();
    }

    public void init(SkeinParameters skeinParameters) {
        this.a.init(skeinParameters);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        return this.a.doFinal(byArray, n2);
    }
}

