/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Generator;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetStringParser;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1SequenceParser;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1SetParser;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1StreamParser;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequenceGenerator;
import com.aspose.cad.internal.bouncycastle.asn1.BERSetParser;
import com.aspose.cad.internal.bouncycastle.asn1.BERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSet;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfoParser;
import com.aspose.cad.internal.bouncycastle.asn1.cms.SignedDataParser;
import com.aspose.cad.internal.bouncycastle.asn1.cms.SignerInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cms.CMSContentInfoParser;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSTypedStream;
import com.aspose.cad.internal.bouncycastle.cms.PKCS7TypedStream;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformation;
import com.aspose.cad.internal.bouncycastle.cms.SignerInformationStore;
import com.aspose.cad.internal.bouncycastle.cms.n;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.util.Store;
import com.aspose.cad.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static final n a = n.a;
    private SignedDataParser b;
    private ASN1ObjectIdentifier c;
    private CMSTypedStream d;
    private Map e;
    private Set<AlgorithmIdentifier> f;
    private SignerInformationStore g;
    private ASN1Set h;
    private ASN1Set i;
    private boolean j;

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws CMSException {
        this(digestCalculatorProvider, new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(digestCalculatorProvider, cMSTypedStream, new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, InputStream inputStream) throws CMSException {
        this(digestCalculatorProvider, null, inputStream);
    }

    public CMSSignedDataParser(DigestCalculatorProvider digestCalculatorProvider, CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        super(inputStream);
        try {
            Object object;
            Object object2;
            ASN1Encodable aSN1Encodable;
            this.d = cMSTypedStream;
            this.b = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this.e = new HashMap();
            ASN1SetParser aSN1SetParser = this.b.getDigestAlgorithms();
            HashSet<AlgorithmIdentifier> hashSet = new HashSet<AlgorithmIdentifier>();
            while ((aSN1Encodable = aSN1SetParser.readObject()) != null) {
                object2 = AlgorithmIdentifier.getInstance(aSN1Encodable);
                hashSet.add((AlgorithmIdentifier)object2);
                try {
                    object = digestCalculatorProvider.get((AlgorithmIdentifier)object2);
                    if (object == null) continue;
                    this.e.put(((AlgorithmIdentifier)object2).getAlgorithm(), object);
                }
                catch (OperatorCreationException operatorCreationException) {}
            }
            this.f = Collections.unmodifiableSet(hashSet);
            object2 = this.b.getEncapContentInfo();
            object = ((ContentInfoParser)object2).getContent(4);
            if (object instanceof ASN1OctetStringParser) {
                ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)object;
                CMSTypedStream cMSTypedStream2 = new CMSTypedStream(((ContentInfoParser)object2).getContentType(), aSN1OctetStringParser.getOctetStream());
                if (this.d == null) {
                    this.d = cMSTypedStream2;
                } else {
                    cMSTypedStream2.drain();
                }
            } else if (object != null) {
                PKCS7TypedStream pKCS7TypedStream = new PKCS7TypedStream(((ContentInfoParser)object2).getContentType(), (ASN1Encodable)object);
                if (this.d == null) {
                    this.d = pKCS7TypedStream;
                } else {
                    pKCS7TypedStream.drain();
                }
            }
            this.c = cMSTypedStream == null ? ((ContentInfoParser)object2).getContentType() : this.d.getContentType();
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
    }

    public int getVersion() {
        return this.b.getVersion().getValue().intValue();
    }

    public Set<AlgorithmIdentifier> getDigestAlgorithmIDs() {
        return this.f;
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this.g == null) {
            this.a();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            for (Object object : this.e.keySet()) {
                hashMap.put(object, ((DigestCalculator)this.e.get(object)).getDigest());
            }
            try {
                ASN1Encodable aSN1Encodable;
                Object object;
                object = this.b.getSignerInfos();
                while ((aSN1Encodable = object.readObject()) != null) {
                    SignerInfo signerInfo = SignerInfo.getInstance(aSN1Encodable.toASN1Primitive());
                    byte[] byArray = (byte[])hashMap.get(signerInfo.getDigestAlgorithm().getAlgorithm());
                    arrayList.add(new SignerInformation(signerInfo, this.c, null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this.g = new SignerInformationStore(arrayList);
        }
        return this.g;
    }

    public Store getCertificates() throws CMSException {
        this.a();
        return a.a(this.h);
    }

    public Store getCRLs() throws CMSException {
        this.a();
        return a.c(this.i);
    }

    public Store getAttributeCertificates() throws CMSException {
        this.a();
        return a.b(this.h);
    }

    public Store getOtherRevocationInfo(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        this.a();
        return a.a(aSN1ObjectIdentifier, this.i);
    }

    private void a() throws CMSException {
        if (this.j) {
            return;
        }
        this.j = true;
        try {
            this.h = CMSSignedDataParser.a(this.b.getCertificates());
            this.i = CMSSignedDataParser.a(this.b.getCrls());
        }
        catch (IOException iOException) {
            throw new CMSException("problem parsing cert/crl sets", iOException);
        }
    }

    public String getSignedContentTypeOID() {
        return this.c.getId();
    }

    public CMSTypedStream getSignedContent() {
        if (this.d == null) {
            return null;
        }
        InputStream inputStream = o.a(this.e.values(), this.d.getContentStream());
        return new CMSTypedStream(this.d.getContentType(), inputStream);
    }

    public static OutputStream replaceSigners(InputStream inputStream, SignerInformationStore signerInformationStore, OutputStream outputStream) throws CMSException, IOException {
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        signedDataParser.getDigestAlgorithms().toASN1Primitive();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (SignerInformation object2 : signerInformationStore.getSigners()) {
            aSN1EncodableVector.add(n.a.a(object2.getDigestAlgorithmID()));
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(contentInfoParser2.getContentType());
        CMSSignedDataParser.a(contentInfoParser2, bERSequenceGenerator3.getRawOutputStream());
        bERSequenceGenerator3.close();
        CMSSignedDataParser.a(bERSequenceGenerator2, signedDataParser.getCertificates(), 0);
        CMSSignedDataParser.a(bERSequenceGenerator2, signedDataParser.getCrls(), 1);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (SignerInformation signerInformation : signerInformationStore.getSigners()) {
            aSN1EncodableVector2.add(signerInformation.toASN1Structure());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector2).getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream inputStream, Store store, Store store2, Store store3, OutputStream outputStream) throws CMSException, IOException {
        Iterable iterable;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream);
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getDigestAlgorithms().toASN1Primitive().getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(contentInfoParser2.getContentType());
        CMSSignedDataParser.a(contentInfoParser2, bERSequenceGenerator3.getRawOutputStream());
        bERSequenceGenerator3.close();
        CMSSignedDataParser.a(signedDataParser.getCertificates());
        CMSSignedDataParser.a(signedDataParser.getCrls());
        if (store != null || store3 != null) {
            ASN1Set aSN1Set;
            iterable = new ArrayList();
            if (store != null) {
                iterable.addAll(o.a(store));
            }
            if (store3 != null) {
                iterable.addAll(o.b(store3));
            }
            if ((aSN1Set = o.a(iterable)).size() > 0) {
                bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, aSN1Set).getEncoded());
            }
        }
        if (store2 != null && ((ASN1Set)(iterable = o.a(o.c(store2)))).size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, (ASN1Encodable)((Object)iterable)).getEncoded());
        }
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getSignerInfos().toASN1Primitive().getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    private static void a(ASN1Generator aSN1Generator, ASN1SetParser aSN1SetParser, int n2) throws IOException {
        ASN1Set aSN1Set = CMSSignedDataParser.a(aSN1SetParser);
        if (aSN1Set != null) {
            if (aSN1SetParser instanceof BERSetParser) {
                aSN1Generator.getRawOutputStream().write(new BERTaggedObject(false, n2, aSN1Set).getEncoded());
            } else {
                aSN1Generator.getRawOutputStream().write(new DERTaggedObject(false, n2, aSN1Set).getEncoded());
            }
        }
    }

    private static ASN1Set a(ASN1SetParser aSN1SetParser) {
        return aSN1SetParser == null ? null : ASN1Set.getInstance(aSN1SetParser.toASN1Primitive());
    }

    private static void a(ContentInfoParser contentInfoParser, OutputStream outputStream) throws IOException {
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser.getContent(4);
        if (aSN1OctetStringParser != null) {
            CMSSignedDataParser.a(aSN1OctetStringParser, outputStream);
        }
    }

    private static void a(ASN1OctetStringParser aSN1OctetStringParser, OutputStream outputStream) throws IOException {
        OutputStream outputStream2 = o.a(outputStream, 0, true, 0);
        Streams.pipeAll(aSN1OctetStringParser.getOctetStream(), outputStream2);
        outputStream2.close();
    }
}

