/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert.crmf.jcajce;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.cad.internal.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.NamedJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import com.aspose.cad.internal.bouncycastle.operator.DefaultSecretKeySizeProvider;
import com.aspose.cad.internal.bouncycastle.operator.GenericKey;
import com.aspose.cad.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.cad.internal.bouncycastle.operator.SecretKeySizeProvider;
import com.aspose.cad.internal.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCRMFEncryptorBuilder {
    private static final SecretKeySizeProvider a = DefaultSecretKeySizeProvider.INSTANCE;
    private final ASN1ObjectIdentifier b;
    private final int c;
    private com.aspose.cad.internal.bouncycastle.cert.crmf.jcajce.a d = new com.aspose.cad.internal.bouncycastle.cert.crmf.jcajce.a(new DefaultJcaJceHelper());
    private SecureRandom e;

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, -1);
    }

    public JceCRMFEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) {
        this.b = aSN1ObjectIdentifier;
        this.c = n2;
    }

    public JceCRMFEncryptorBuilder setProvider(Provider provider) {
        this.d = new com.aspose.cad.internal.bouncycastle.cert.crmf.jcajce.a(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceCRMFEncryptorBuilder setProvider(String string) {
        this.d = new com.aspose.cad.internal.bouncycastle.cert.crmf.jcajce.a(new NamedJcaJceHelper(string));
        return this;
    }

    public JceCRMFEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.e = secureRandom;
        return this;
    }

    public OutputEncryptor build() throws CRMFException {
        return new a(this.b, this.c, this.e);
    }

    private class a
    implements OutputEncryptor {
        private SecretKey b;
        private AlgorithmIdentifier c;
        private Cipher d;

        a(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, SecureRandom secureRandom) throws CRMFException {
            KeyGenerator keyGenerator = JceCRMFEncryptorBuilder.this.d.b(aSN1ObjectIdentifier);
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            if (n2 < 0) {
                n2 = a.getKeySize(aSN1ObjectIdentifier);
            }
            if (n2 < 0) {
                keyGenerator.init(secureRandom);
            } else {
                keyGenerator.init(n2, secureRandom);
            }
            this.d = JceCRMFEncryptorBuilder.this.d.a(aSN1ObjectIdentifier);
            this.b = keyGenerator.generateKey();
            AlgorithmParameters algorithmParameters = JceCRMFEncryptorBuilder.this.d.a(aSN1ObjectIdentifier, this.b, secureRandom);
            try {
                this.d.init(1, (Key)this.b, algorithmParameters, secureRandom);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CRMFException("unable to initialize cipher: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            if (algorithmParameters == null) {
                algorithmParameters = this.d.getParameters();
            }
            this.c = JceCRMFEncryptorBuilder.this.d.a(aSN1ObjectIdentifier, algorithmParameters);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.d);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.c, this.b);
        }
    }
}

