/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1GeneralizedTime;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DERSet;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AttCertIssuer;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Attribute;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.aspose.cad.internal.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import com.aspose.cad.internal.bouncycastle.cert.AttributeCertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.AttributeCertificateIssuer;
import com.aspose.cad.internal.bouncycastle.cert.CertIOException;
import com.aspose.cad.internal.bouncycastle.cert.X509AttributeCertificateHolder;
import com.aspose.cad.internal.bouncycastle.cert.a;
import com.aspose.cad.internal.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;

public class X509v2AttributeCertificateBuilder {
    private V2AttributeCertificateInfoGenerator a = new V2AttributeCertificateInfoGenerator();
    private ExtensionsGenerator b = new ExtensionsGenerator();

    public X509v2AttributeCertificateBuilder(AttributeCertificateHolder attributeCertificateHolder, AttributeCertificateIssuer attributeCertificateIssuer, BigInteger bigInteger, Date date, Date date2) {
        this.a.setHolder(attributeCertificateHolder.holder);
        this.a.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.form));
        this.a.setSerialNumber(new ASN1Integer(bigInteger));
        this.a.setStartDate(new ASN1GeneralizedTime(date));
        this.a.setEndDate(new ASN1GeneralizedTime(date2));
    }

    public X509v2AttributeCertificateBuilder(AttributeCertificateHolder attributeCertificateHolder, AttributeCertificateIssuer attributeCertificateIssuer, BigInteger bigInteger, Date date, Date date2, Locale locale) {
        this.a.setHolder(attributeCertificateHolder.holder);
        this.a.setIssuer(AttCertIssuer.getInstance(attributeCertificateIssuer.form));
        this.a.setSerialNumber(new ASN1Integer(bigInteger));
        this.a.setStartDate(new ASN1GeneralizedTime(date, locale));
        this.a.setEndDate(new ASN1GeneralizedTime(date2, locale));
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.a.addAttribute(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1Encodable)));
        return this;
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable[] aSN1EncodableArray) {
        this.a.addAttribute(new Attribute(aSN1ObjectIdentifier, new DERSet(aSN1EncodableArray)));
        return this;
    }

    public void setIssuerUniqueId(boolean[] blArray) {
        this.a.setIssuerUniqueID(com.aspose.cad.internal.bouncycastle.cert.a.a(blArray));
    }

    public X509v2AttributeCertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) throws CertIOException {
        com.aspose.cad.internal.bouncycastle.cert.a.a(this.b, aSN1ObjectIdentifier, bl2, aSN1Encodable);
        return this;
    }

    public X509v2AttributeCertificateBuilder addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) throws CertIOException {
        this.b.addExtension(aSN1ObjectIdentifier, bl2, byArray);
        return this;
    }

    public X509v2AttributeCertificateBuilder addExtension(Extension extension) throws CertIOException {
        this.b.addExtension(extension);
        return this;
    }

    public X509AttributeCertificateHolder build(ContentSigner contentSigner) {
        this.a.setSignature(contentSigner.getAlgorithmIdentifier());
        if (!this.b.isEmpty()) {
            this.a.setExtensions(this.b.generate());
        }
        return com.aspose.cad.internal.bouncycastle.cert.a.a(contentSigner, this.a.generateAttributeCertificateInfo());
    }
}

