/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cert;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.cad.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.cad.internal.bouncycastle.cert.a;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509CRLEntryHolder {
    private TBSCertList.CRLEntry a;
    private GeneralNames b;

    X509CRLEntryHolder(TBSCertList.CRLEntry cRLEntry, boolean bl2, GeneralNames generalNames) {
        Extension extension;
        this.a = cRLEntry;
        this.b = generalNames;
        if (bl2 && cRLEntry.hasExtensions() && (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) != null) {
            this.b = GeneralNames.getInstance(extension.getParsedValue());
        }
    }

    public BigInteger getSerialNumber() {
        return this.a.getUserCertificate().getValue();
    }

    public Date getRevocationDate() {
        return this.a.getRevocationDate().getDate();
    }

    public boolean hasExtensions() {
        return this.a.hasExtensions();
    }

    public GeneralNames getCertificateIssuer() {
        return this.b;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Extensions extensions = this.a.getExtensions();
        if (extensions != null) {
            return extensions.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.a.getExtensions();
    }

    public List getExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.a.c(this.a.getExtensions());
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.a.a(this.a.getExtensions());
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.cad.internal.bouncycastle.cert.a.b(this.a.getExtensions());
    }
}

