/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.x509;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.cad.internal.bouncycastle.asn1.x509.Extensions;
import java.math.BigInteger;

public class PolicyConstraints
extends ASN1Object {
    private BigInteger a;
    private BigInteger b;

    public PolicyConstraints(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger;
        this.b = bigInteger2;
    }

    private PolicyConstraints(ASN1Sequence aSN1Sequence) {
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i2));
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                continue;
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                this.b = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue();
                continue;
            }
            throw new IllegalArgumentException("Unknown tag encountered.");
        }
    }

    public static PolicyConstraints getInstance(Object object) {
        if (object instanceof PolicyConstraints) {
            return (PolicyConstraints)object;
        }
        if (object != null) {
            return new PolicyConstraints(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static PolicyConstraints fromExtensions(Extensions extensions) {
        return PolicyConstraints.getInstance(extensions.getExtensionParsedValue(Extension.policyConstraints));
    }

    public BigInteger getRequireExplicitPolicyMapping() {
        return this.a;
    }

    public BigInteger getInhibitPolicyMapping() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, new ASN1Integer(this.a)));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, new ASN1Integer(this.b)));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

