/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Boolean;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERUTF8String;
import com.aspose.cad.internal.bouncycastle.asn1.cms.Attributes;

public class MetaData
extends ASN1Object {
    private ASN1Boolean a;
    private DERUTF8String b;
    private DERIA5String c;
    private Attributes d;

    public MetaData(ASN1Boolean aSN1Boolean, DERUTF8String dERUTF8String, DERIA5String dERIA5String, Attributes attributes) {
        this.a = aSN1Boolean;
        this.b = dERUTF8String;
        this.c = dERIA5String;
        this.d = attributes;
    }

    private MetaData(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Boolean.getInstance(aSN1Sequence.getObjectAt(0));
        int n2 = 1;
        if (n2 < aSN1Sequence.size() && aSN1Sequence.getObjectAt(n2) instanceof DERUTF8String) {
            this.b = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (n2 < aSN1Sequence.size() && aSN1Sequence.getObjectAt(n2) instanceof DERIA5String) {
            this.c = DERIA5String.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (n2 < aSN1Sequence.size()) {
            this.d = Attributes.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
    }

    public static MetaData getInstance(Object object) {
        if (object instanceof MetaData) {
            return (MetaData)object;
        }
        if (object != null) {
            return new MetaData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public boolean isHashProtected() {
        return this.a.isTrue();
    }

    public DERUTF8String getFileName() {
        return this.b;
    }

    public DERIA5String getMediaType() {
        return this.c;
    }

    public Attributes getOtherMetaData() {
        return this.d;
    }
}

