/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Exception;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.l;
import java.io.IOException;
import java.util.Enumeration;

public class BERTaggedObject
extends ASN1TaggedObject {
    public BERTaggedObject(int n2, ASN1Encodable aSN1Encodable) {
        super(true, n2, aSN1Encodable);
    }

    public BERTaggedObject(boolean bl2, int n2, ASN1Encodable aSN1Encodable) {
        super(bl2, n2, aSN1Encodable);
    }

    public BERTaggedObject(int n2) {
        super(false, n2, new BERSequence());
    }

    @Override
    boolean isConstructed() {
        if (!this.empty) {
            if (this.explicit) {
                return true;
            }
            ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive().toDERObject();
            return aSN1Primitive.isConstructed();
        }
        return true;
    }

    @Override
    int encodedLength() throws IOException {
        if (!this.empty) {
            ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive();
            int n2 = aSN1Primitive.encodedLength();
            if (this.explicit) {
                return l.b(this.tagNo) + l.a(n2) + n2;
            }
            return l.b(this.tagNo) + --n2;
        }
        return l.b(this.tagNo) + 1;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeTag(160, this.tagNo);
        aSN1OutputStream.write(128);
        if (!this.empty) {
            if (!this.explicit) {
                Enumeration enumeration;
                if (this.obj instanceof ASN1OctetString) {
                    if (this.obj instanceof BEROctetString) {
                        enumeration = ((BEROctetString)this.obj).getObjects();
                    } else {
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)this.obj;
                        BEROctetString bEROctetString = new BEROctetString(aSN1OctetString.getOctets());
                        enumeration = bEROctetString.getObjects();
                    }
                } else if (this.obj instanceof ASN1Sequence) {
                    enumeration = ((ASN1Sequence)this.obj).getObjects();
                } else if (this.obj instanceof ASN1Set) {
                    enumeration = ((ASN1Set)this.obj).getObjects();
                } else {
                    throw new ASN1Exception("not implemented: " + this.obj.getClass().getName());
                }
                while (enumeration.hasMoreElements()) {
                    aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
                }
            } else {
                aSN1OutputStream.writeObject(this.obj);
            }
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

