/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad;

import com.aspose.cad.Color;
import com.aspose.cad.DataStreamSupporter;
import com.aspose.cad.FileStreamContainer;
import com.aspose.cad.IColorPalette;
import com.aspose.cad.IImageExporter;
import com.aspose.cad.IImageLoader;
import com.aspose.cad.IImageLoaderDescriptor;
import com.aspose.cad.IObjectWithBounds;
import com.aspose.cad.ImageExportersRegistry;
import com.aspose.cad.ImageLoadersRegistry;
import com.aspose.cad.ImageOptionsBase;
import com.aspose.cad.LoadOptions;
import com.aspose.cad.Point;
import com.aspose.cad.Rectangle;
import com.aspose.cad.Size;
import com.aspose.cad.StreamContainer;
import com.aspose.cad.cadexceptions.FrameworkException;
import com.aspose.cad.cadexceptions.ImageException;
import com.aspose.cad.cadexceptions.ImageLoadException;
import com.aspose.cad.cadexceptions.ImageSaveException;
import com.aspose.cad.imageoptions.CadRasterizationOptions;
import com.aspose.cad.internal.D.aW;
import com.aspose.cad.internal.D.bD;
import com.aspose.cad.internal.D.g;
import com.aspose.cad.internal.Exceptions.ArgumentException;
import com.aspose.cad.internal.Exceptions.ArgumentNullException;
import com.aspose.cad.internal.S.k;
import com.aspose.cad.internal.eI.c;
import com.aspose.cad.internal.eJ.d;
import com.aspose.cad.internal.eL.a;
import com.aspose.cad.internal.eQ.i;
import com.aspose.cad.internal.iR.av;
import com.aspose.cad.internal.jP.bR;
import com.aspose.cad.internal.jP.bS;
import com.aspose.cad.system.collections.Generic.Dictionary;
import com.aspose.cad.system.collections.Generic.List;
import com.aspose.cad.system.io.FileStream;
import com.aspose.cad.system.io.Stream;
import com.aspose.cad.w;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds {
    private Image k;
    private IColorPalette l;
    private Object m;
    private double n;
    private Dictionary<String, String> o;
    protected int unitType = 17;
    protected LoadOptions loadOptions;

    protected Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.l = iColorPalette;
    }

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty().Clone(), this.getSize().Clone());
    }

    public Image getContainer() {
        return this.k;
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.l;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.l != iColorPalette) {
            IColorPalette iColorPalette2 = this.l;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.l = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    @Deprecated
    public boolean hasBackgroundColor() {
        return false;
    }

    @Deprecated
    public void setBackgroundColor(boolean bl2) {
    }

    @Deprecated
    public Color getBackgroundColor() {
        return Color.getWhite();
    }

    @Deprecated
    public void setBackgroundColor(Color color) {
    }

    public int getUnitType() {
        return this.unitType;
    }

    public String[] getAttributes() {
        return new String[0];
    }

    public static boolean canLoad(String string) {
        return Image.canLoad(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String string, LoadOptions loadOptions) {
        FileStream fileStream = com.aspose.cad.internal.S.k.f(string);
        try {
            boolean bl2 = Image.canLoad_internalized(fileStream);
            return bl2;
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    public static boolean canLoad(InputStream inputStream) {
        return Image.canLoad_internalized(Stream.fromJava(inputStream));
    }

    static boolean canLoad_internalized(Stream stream) {
        return Image.canLoad_internalized(stream, null);
    }

    public static boolean canLoad(InputStream inputStream, LoadOptions loadOptions) {
        return Image.canLoad_internalized(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canLoad_internalized(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        bR bR2 = null;
        try {
            bR2 = bS.a().a(stream);
            bl2 = ImageLoadersRegistry.getFirstSupportedDescriptor_internalized(bR2, loadOptions) != null;
        }
        finally {
            bS.a().a(bR2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String string) {
        FileStream fileStream = com.aspose.cad.internal.S.k.a(string, 3, 1, 1);
        bR bR2 = bS.a().a(fileStream);
        try {
            long l2 = Image.getFileFormat_internalized(bR2);
            return l2;
        }
        finally {
            if (bR2.a() <= 0) {
                bR2.dispose();
            }
        }
    }

    public static long getFileFormat(InputStream inputStream) {
        return Image.getFileFormat_internalized(Stream.fromJava(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getFileFormat_internalized(Stream stream) {
        IImageLoaderDescriptor iImageLoaderDescriptor;
        StreamContainer streamContainer;
        long l2;
        block14: {
            Object object;
            l2 = 0L;
            streamContainer = new StreamContainer(stream);
            iImageLoaderDescriptor = null;
            try {
                object = new List<IImageLoaderDescriptor>();
                ((List)object).addRange(com.aspose.cad.internal.D.g.a(ImageLoadersRegistry.getRegisteredDescriptors()));
                for (int i2 = ((List)object).size() - 1; i2 >= 0; --i2) {
                    IImageLoaderDescriptor iImageLoaderDescriptor2 = (IImageLoaderDescriptor)((List)object).get_Item(i2);
                    streamContainer.seekBegin();
                    if (!iImageLoaderDescriptor2.canLoad(streamContainer, null)) continue;
                    iImageLoaderDescriptor = iImageLoaderDescriptor2;
                    break;
                }
                if (streamContainer.isStreamDisposedOnClose()) break block14;
                object = null;
            }
            catch (Throwable throwable) {
                if (!streamContainer.isStreamDisposedOnClose()) {
                    bR bR2 = null;
                    bR[] bRArray = new bR[]{bR2};
                    boolean bl2 = bR.a(streamContainer, bRArray);
                    bR2 = bRArray[0];
                    if (bl2) {
                        bS.a().a(bR2);
                    }
                }
                streamContainer.seekBegin();
                streamContainer.dispose();
                throw throwable;
            }
            bR[] bRArray = new bR[]{object};
            boolean bl3 = bR.a(streamContainer, bRArray);
            object = bRArray[0];
            if (bl3) {
                bS.a().a((bR)object);
            }
        }
        streamContainer.seekBegin();
        streamContainer.dispose();
        if (iImageLoaderDescriptor == null) {
            block15: {
                long l3;
                block16: {
                    bR bR3;
                    streamContainer = new StreamContainer(stream);
                    try {
                        streamContainer.seekBegin();
                        long l4 = Image.a(av.g(stream));
                        if (l4 == 0L) break block15;
                        l3 = l4;
                        if (streamContainer.isStreamDisposedOnClose()) break block16;
                        bR3 = null;
                    }
                    catch (Throwable throwable) {
                        if (!streamContainer.isStreamDisposedOnClose()) {
                            bR bR4 = null;
                            bR[] bRArray = new bR[]{bR4};
                            boolean bl4 = bR.a(streamContainer, bRArray);
                            bR4 = bRArray[0];
                            if (bl4) {
                                bS.a().a(bR4);
                            }
                        }
                        streamContainer.seekBegin();
                        streamContainer.dispose();
                        throw throwable;
                    }
                    bR[] bRArray = new bR[]{bR3};
                    boolean bl5 = bR.a(streamContainer, bRArray);
                    bR3 = bRArray[0];
                    if (bl5) {
                        bS.a().a(bR3);
                    }
                }
                streamContainer.seekBegin();
                streamContainer.dispose();
                return l3;
            }
            if (!streamContainer.isStreamDisposedOnClose()) {
                bR bR5 = null;
                bR[] bRArray = new bR[]{bR5};
                boolean bl6 = bR.a(streamContainer, bRArray);
                bR5 = bRArray[0];
                if (bl6) {
                    bS.a().a(bR5);
                }
            }
            streamContainer.seekBegin();
            streamContainer.dispose();
        }
        return iImageLoaderDescriptor != null ? iImageLoaderDescriptor.a(stream) : l2;
    }

    private static long a(long l2) {
        switch ((int)l2) {
            case 2: {
                return 2L;
            }
            case 4: {
                return 3L;
            }
            case 8: {
                return 4L;
            }
            case 512: {
                return 9L;
            }
            case 16: {
                return 5L;
            }
            case 64: {
                return 7L;
            }
            case 32: {
                return 6L;
            }
        }
        return 0L;
    }

    protected static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle.Clone(), new Rectangle(new Point(), new Size(bD.a(n2), bD.a(n3)))).Clone();
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    protected static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle.Clone(), n2, n3).Clone();
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aW.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{com.aspose.cad.internal.eJ.d.b(rectangle2.getWidth() * rectangle2.getHeight()), com.aspose.cad.internal.eJ.d.b(nArray.length)});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static Image load(String string, LoadOptions loadOptions) {
        return Image.a(FileStreamContainer.a(string, true), loadOptions);
    }

    public static Image load(String string) {
        return Image.a(FileStreamContainer.a(string, true), null);
    }

    public static Image load(InputStream inputStream, LoadOptions loadOptions) {
        return Image.load_internalized(Stream.fromJava(inputStream), loadOptions);
    }

    static Image load_internalized(Stream stream, LoadOptions loadOptions) {
        return Image.a(new StreamContainer(stream, 0L, false), loadOptions);
    }

    public static Image load(InputStream inputStream) {
        return Image.f(Stream.fromJava(inputStream));
    }

    public static Image f(Stream stream) {
        return Image.load_internalized(stream, null);
    }

    public boolean canSave(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, imageOptionsBase) != null;
    }

    @Override
    public final void save() {
        this.saveInternal_internalized();
        if (this.getDataStreamContainer() != null) {
            this.g(this.getDataStreamContainer().a());
        }
    }

    void saveInternal_internalized() {
        if (this.k != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        super.save();
    }

    public void save(String string, ImageOptionsBase imageOptionsBase) {
        this.saveInternal_internalized(string, imageOptionsBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveInternal_internalized(String string, ImageOptionsBase imageOptionsBase) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        try {
            FileStream fileStream = com.aspose.cad.internal.S.k.b(string);
            try {
                this.a(fileStream, imageOptionsBase);
                fileStream.flush();
            }
            finally {
                if (fileStream != null) {
                    fileStream.dispose();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase) {
        if (outputStream instanceof com.aspose.cad.internal.dX.d) {
            this.save_internalized(((com.aspose.cad.internal.dX.d)outputStream).a(), imageOptionsBase);
        } else {
            com.aspose.cad.internal.eI.c.a(new w(this, outputStream, imageOptionsBase));
        }
    }

    void save_internalized(Stream stream, ImageOptionsBase imageOptionsBase) {
        this.a(stream, imageOptionsBase);
        this.g(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(Stream stream, ImageOptionsBase imageOptionsBase) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (imageOptionsBase != null && imageOptionsBase.getVectorRasterizationOptions() == null) {
            imageOptionsBase.setVectorRasterizationOptions(new CadRasterizationOptions());
        }
        try {
            IImageExporter iImageExporter = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (iImageExporter == null) {
                throw new ArgumentException("Cannot save to the specified format as it is not supported at the moment.", "optionsBase");
            }
            CadRasterizationOptions cadRasterizationOptions = (CadRasterizationOptions)((Object)com.aspose.cad.internal.eJ.d.a(imageOptionsBase.getVectorRasterizationOptions(), CadRasterizationOptions.class));
            if (cadRasterizationOptions != null) {
                com.aspose.cad.internal.eQ.i.a(cadRasterizationOptions.getPenOptions());
            }
            bR bR2 = null;
            try {
                bR2 = bS.a().a(stream);
                iImageExporter.export(this, stream.toOutputStream(), imageOptionsBase, Rectangle.getEmpty().Clone());
                this.g(stream);
            }
            finally {
                bS.a().a(bR2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
    }

    public final String getAttributeValue(String string) {
        if (this.o == null || this.o.size() <= 0) {
            return aW.a;
        }
        for (String string2 : this.getAttributes()) {
            if (!aW.d(string2, string, (short)3) || !this.o.containsKey(string2)) continue;
            return this.o.get_Item(string2);
        }
        return aW.a;
    }

    public void a(Object object) {
        this.m = object;
    }

    public Object e() {
        return this.m;
    }

    void setContainer(Image image) {
        this.k = image;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle.Clone(), this.getWidth(), this.getHeight());
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle.Clone(), nArray, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    @Override
    protected void releaseManagedResources() {
        this.k = null;
        this.l = null;
        super.releaseManagedResources();
        if (this.loadOptions == null || this.loadOptions.getUnloadOnDispose()) {
            this.releaseContents();
            System.gc();
            System.runFinalization();
            Thread.yield();
        }
    }

    protected void releaseContents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image a(StreamContainer streamContainer, LoadOptions loadOptions) {
        try {
            IImageLoader iImageLoader = ImageLoadersRegistry.createFirstSupportedLoader_internalized(StreamContainer.to_Stream(streamContainer), loadOptions);
            if (iImageLoader == null) {
                Integer n2 = ImageLoadersRegistry.getCadImageFormatByExtension((FileStreamContainer)((Object)com.aspose.cad.internal.eJ.d.a(streamContainer, FileStreamContainer.class)));
                if (n2 != null) {
                    throw new a().a(n2);
                }
                throw new ImageLoadException("Cannot open an image. The image file format may be not supported at the moment.");
            }
            Image image = iImageLoader.load(streamContainer, loadOptions);
            image.loadOptions = loadOptions;
            image.a(streamContainer);
            Image image2 = image;
            synchronized (image2) {
                image.n = com.aspose.cad.internal.hY.a.a().a(StreamContainer.to_Stream(streamContainer));
            }
            return image;
        }
        catch (RuntimeException runtimeException) {
            bS bS2 = (bS)bS.a();
            bS.a(streamContainer);
            throw new ImageLoadException("Image loading failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(Stream stream) {
        double d2 = com.aspose.cad.internal.hY.a.b(stream);
        double d3 = d2 - this.n;
        if (d3 > 0.0) {
            Image image = this;
            synchronized (image) {
                this.n = 0.0;
            }
            com.aspose.cad.internal.hY.a.a().a(d3);
        } else {
            Image image = this;
            synchronized (image) {
                double[] dArray = new double[]{this.n};
                Image.a(dArray, -d2);
                this.n = dArray[0];
            }
        }
    }

    private static double a(double[] dArray, double d2) {
        double d3;
        double d4;
        double d5 = 0.0;
        while (!(bD.a((d5 = Image.a(dArray, d4 = (d3 = d5) + d2, d3)) - d3) < 1.0E-9)) {
        }
        return d4;
    }

    private static double a(double[] dArray, double d2, double d3) {
        double d4 = dArray[0];
        if (dArray[0] == d3) {
            dArray[0] = d2;
        }
        return d4;
    }

    public final void a(String string, String string2) {
        if (this.o == null) {
            this.o = new Dictionary();
        }
        for (String string3 : this.getAttributes()) {
            if (!aW.d(string3, string, (short)3)) continue;
            if (this.o.containsKey(string3)) {
                this.o.set_Item(string3, string2);
                continue;
            }
            this.o.addItem(string3, string2);
        }
    }
}

