/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.digest;

import com.aspose.cad.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.digest.a;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public class SHA256 {
    private SHA256() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA256Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA256Digest((SHA256Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA256Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA256", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends a {
        private static final String a = SHA256.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-256", a + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA256", "SHA-256");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha256, "SHA-256");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHHMACSHA256", a + "$PBEWithMacKeyFactory");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHHMACSHA-256", "PBEWITHHMACSHA256");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory." + NISTObjectIdentifiers.id_sha256, "PBEWITHHMACSHA256");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACSHA256", a + "$HashMac");
            this.addHMACAlgorithm(configurableProvider, "SHA256", a + "$HashMac", a + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
            this.addHMACAlias(configurableProvider, "SHA256", NISTObjectIdentifiers.id_sha256);
        }
    }

    public static class PBEWithMacKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithMacKeyFactory() {
            super("PBEwithHmacSHA256", null, false, 2, 4, 256, 0);
        }
    }
}

