/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.ec;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.ec.ECPair;
import com.aspose.cad.internal.bouncycastle.crypto.ec.ECPairFactorTransform;
import com.aspose.cad.internal.bouncycastle.crypto.ec.G;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.cad.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.cad.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNewRandomnessTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters a;
    private SecureRandom b;
    private BigInteger c;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            if (!(parametersWithRandom.getParameters() instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.a = (ECPublicKeyParameters)parametersWithRandom.getParameters();
            this.b = parametersWithRandom.getRandom();
        } else {
            if (!(cipherParameters instanceof ECPublicKeyParameters)) {
                throw new IllegalArgumentException("ECPublicKeyParameters are required for new randomness transform.");
            }
            this.a = (ECPublicKeyParameters)cipherParameters;
            this.b = new SecureRandom();
        }
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        if (this.a == null) {
            throw new IllegalStateException("ECNewRandomnessTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.a.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = G.a(bigInteger, this.b);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).add(eCPair.getX()), this.a.getQ().multiply(bigInteger2).add(eCPair.getY())};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        this.c = bigInteger2;
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    @Override
    public BigInteger getTransformValue() {
        return this.c;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

