/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.esf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.esf.CrlListID;
import com.aspose.cad.internal.bouncycastle.asn1.esf.OcspListID;
import com.aspose.cad.internal.bouncycastle.asn1.esf.OtherRevRefs;
import java.util.Enumeration;

public class CrlOcspRef
extends ASN1Object {
    private CrlListID a;
    private OcspListID b;
    private OtherRevRefs c;

    public static CrlOcspRef getInstance(Object object) {
        if (object instanceof CrlOcspRef) {
            return (CrlOcspRef)object;
        }
        if (object != null) {
            return new CrlOcspRef(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlOcspRef(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = CrlListID.getInstance(aSN1TaggedObject.getObject());
                    continue block5;
                }
                case 1: {
                    this.b = OcspListID.getInstance(aSN1TaggedObject.getObject());
                    continue block5;
                }
                case 2: {
                    this.c = OtherRevRefs.getInstance(aSN1TaggedObject.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("illegal tag");
        }
    }

    public CrlOcspRef(CrlListID crlListID, OcspListID ocspListID, OtherRevRefs otherRevRefs) {
        this.a = crlListID;
        this.b = ocspListID;
        this.c = otherRevRefs;
    }

    public CrlListID getCrlids() {
        return this.a;
    }

    public OcspListID getOcspids() {
        return this.b;
    }

    public OtherRevRefs getOtherRev() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (null != this.a) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a.toASN1Primitive()));
        }
        if (null != this.b) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b.toASN1Primitive()));
        }
        if (null != this.c) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.c.toASN1Primitive()));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

