/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.dvcs;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;

public class DVCSErrorNotice
extends ASN1Object {
    private PKIStatusInfo a;
    private GeneralName b;

    public DVCSErrorNotice(PKIStatusInfo pKIStatusInfo) {
        this(pKIStatusInfo, null);
    }

    public DVCSErrorNotice(PKIStatusInfo pKIStatusInfo, GeneralName generalName) {
        this.a = pKIStatusInfo;
        this.b = generalName;
    }

    private DVCSErrorNotice(ASN1Sequence aSN1Sequence) {
        this.a = PKIStatusInfo.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = GeneralName.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public static DVCSErrorNotice getInstance(Object object) {
        if (object instanceof DVCSErrorNotice) {
            return (DVCSErrorNotice)object;
        }
        if (object != null) {
            return new DVCSErrorNotice(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSErrorNotice getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DVCSErrorNotice.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "DVCSErrorNotice {\ntransactionStatus: " + this.a + "\n" + (this.b != null ? "transactionIdentifier: " + this.b + "\n" : "") + "}\n";
    }

    public PKIStatusInfo getTransactionStatus() {
        return this.a;
    }

    public GeneralName getTransactionIdentifier() {
        return this.b;
    }
}

