/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.selectors;

import org.jfree.layouting.input.style.selectors.AbstractSelector;
import org.jfree.layouting.input.style.selectors.SelectorWeight;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.SimpleSelector;

public class CSSConditionalSelector
extends AbstractSelector
implements ConditionalSelector {
    private static final int ID_CONDITION = 0;
    private static final int ATTR_CONDITION = 1;
    private static final int OTHER_CONDITION = 2;
    private Condition condition;
    private SimpleSelector simpleSelector;

    public CSSConditionalSelector(SimpleSelector simpleSelector, Condition condition) {
        this.simpleSelector = simpleSelector;
        this.condition = condition;
    }

    @Override
    protected SelectorWeight createWeight() {
        int[] nArray = new int[3];
        this.countConditions(nArray, this.condition);
        return new SelectorWeight(0, nArray[0], nArray[1], nArray[2] + 1);
    }

    private void countConditions(int[] nArray, Condition condition) {
        if (condition.getConditionType() == 5) {
            nArray[0] = nArray[0] + 1;
        } else if (condition instanceof AttributeCondition) {
            nArray[1] = nArray[1] + 1;
        } else if (condition instanceof CombinatorCondition) {
            CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
            this.countConditions(nArray, combinatorCondition.getFirstCondition());
            this.countConditions(nArray, combinatorCondition.getSecondCondition());
        } else {
            nArray[2] = nArray[2] + 1;
        }
    }

    public SimpleSelector getSimpleSelector() {
        return this.simpleSelector;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public short getSelectorType() {
        return 0;
    }
}

