/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow;

import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.ReportContextImpl;
import org.jfree.report.flow.DefaultFlowController;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportProcessor;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.DefaultLayoutControllerFactory;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;

public abstract class AbstractReportProcessor
implements ReportProcessor {
    protected AbstractReportProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReportRun(ReportJob reportJob, ReportTarget reportTarget) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        ReportJob reportJob2 = reportJob;
        synchronized (reportJob2) {
            ReportContext reportContext = this.createReportContext(reportJob, reportTarget);
            LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
            FlowController flowController = this.createFlowControler(reportContext, reportJob);
            LayoutController layoutController = layoutControllerFactory.create(flowController, reportJob.getReportStructureRoot(), null);
            while (layoutController.isAdvanceable()) {
                layoutController = layoutController.advance(reportTarget);
                while (!layoutController.isAdvanceable() && layoutController.getParent() != null) {
                    LayoutController layoutController2 = layoutController.getParent();
                    reportTarget.commit();
                    layoutController = layoutController2.join(layoutController.getFlowController());
                }
            }
            reportTarget.commit();
        }
    }

    protected ReportContext createReportContext(ReportJob reportJob, ReportTarget reportTarget) {
        ReportContextImpl reportContextImpl = new ReportContextImpl();
        reportContextImpl.setExportDescriptor(reportTarget.getExportDescriptor());
        DefaultLayoutControllerFactory defaultLayoutControllerFactory = new DefaultLayoutControllerFactory();
        defaultLayoutControllerFactory.initialize(reportJob);
        reportContextImpl.setLayoutControllerFactory(defaultLayoutControllerFactory);
        DefaultFormulaContext defaultFormulaContext = new DefaultFormulaContext();
        reportContextImpl.setFormulaContext((FormulaContext)defaultFormulaContext);
        reportContextImpl.setResourceBundleFactory(reportJob.getResourceBundleFactory());
        reportContextImpl.setReportStructureRoot(reportJob.getReportStructureRoot());
        return reportContextImpl;
    }

    protected FlowController createFlowControler(ReportContext reportContext, ReportJob reportJob) throws DataSourceException {
        return new DefaultFlowController(reportContext, reportJob);
    }
}

