/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.BackgroundSpecification;
import org.jfree.layouting.layouter.context.ContentSpecification;
import org.jfree.layouting.layouter.context.ContextId;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.LayoutStyle;
import org.jfree.layouting.layouter.context.ListSpecification;
import org.jfree.layouting.layouter.style.LayoutStyleImpl;
import org.jfree.layouting.util.AttributeMap;

public class DefaultLayoutContext
implements LayoutContext,
Cloneable {
    private static Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private BackgroundSpecification backgroundSpecification;
    private FontSpecification fontSpecification;
    private ContentSpecification contentSpecification;
    private ListSpecification listSpecification;
    private LayoutStyleImpl style;
    private ContextId contextId;
    private String namespace;
    private String tagName;
    private AttributeMap attributeMap;
    private String pseudoElement;
    private boolean derived;
    private Map counters;
    private Map strings;

    public DefaultLayoutContext(ContextId contextId, String string, String string2, String string3, AttributeMap attributeMap) {
        this.pseudoElement = string3;
        if (contextId == null) {
            throw new NullPointerException();
        }
        if (attributeMap == null) {
            throw new NullPointerException();
        }
        this.namespace = string;
        this.tagName = string2;
        this.attributeMap = attributeMap;
        this.contextId = contextId;
        this.style = new LayoutStyleImpl();
        this.fontSpecification = new FontSpecification(this.style);
        this.backgroundSpecification = new BackgroundSpecification();
        this.contentSpecification = new ContentSpecification();
        this.listSpecification = new ListSpecification();
        this.strings = EMPTY_MAP;
        this.counters = EMPTY_MAP;
    }

    @Override
    public String getPseudoElement() {
        return this.pseudoElement;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attributeMap;
    }

    @Override
    public BackgroundSpecification getBackgroundSpecification() {
        return this.backgroundSpecification;
    }

    @Override
    public FontSpecification getFontSpecification() {
        return this.fontSpecification;
    }

    @Override
    public ContentSpecification getContentSpecification() {
        return this.contentSpecification;
    }

    @Override
    public ListSpecification getListSpecification() {
        return this.listSpecification;
    }

    @Override
    public void setValue(StyleKey styleKey, CSSValue cSSValue) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        this.style.setValue(styleKey, cSSValue);
    }

    @Override
    public CSSValue getValue(StyleKey styleKey) {
        return this.style.getValue(styleKey);
    }

    public LayoutStyle getStyle() {
        return this.style;
    }

    @Override
    public ContextId getContextId() {
        return this.contextId;
    }

    @Override
    public Locale getLanguage() {
        return Locale.getDefault();
    }

    @Override
    public boolean isPseudoElement() {
        return this.pseudoElement != null;
    }

    public Object clone() {
        try {
            DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)super.clone();
            defaultLayoutContext.derived = true;
            return defaultLayoutContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Invalid implementation: Clone not supported.");
        }
    }

    @Override
    public LayoutContext derive() {
        DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)this.clone();
        defaultLayoutContext.tagName = this.tagName + '*';
        return defaultLayoutContext;
    }

    @Override
    public void dispose() {
        this.style.dispose();
    }

    @Override
    public boolean copyFrom(LayoutStyle layoutStyle) {
        if (this.derived) {
            throw new IllegalStateException();
        }
        return this.style.copyFrom(layoutStyle);
    }

    @Override
    public Map getCounters() {
        return this.counters;
    }

    @Override
    public Map getStrings() {
        return this.strings;
    }

    @Override
    public LayoutContext detach(Map map, Map map2) {
        DefaultLayoutContext defaultLayoutContext = (DefaultLayoutContext)this.derive();
        if (map2 != null) {
            defaultLayoutContext.strings = Collections.unmodifiableMap(map2);
        }
        if (map != null) {
            defaultLayoutContext.counters = Collections.unmodifiableMap(map);
        }
        return defaultLayoutContext;
    }
}

