/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.State;
import org.jfree.layouting.StateException;
import org.jfree.layouting.StatefullComponent;
import org.jfree.layouting.layouter.content.ContentToken;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.context.PageContext;
import org.jfree.layouting.normalizer.content.NormalizationException;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.util.ChainingComponent;

public class ChainingRenderer
extends ChainingComponent
implements Renderer {
    private static final int MTH_START_DOCUMENT = 1;
    private static final int MTH_START_SPECIAL_FLOW = 2;
    private static final int MTH_START_FLOW = 3;
    private static final int MTH_START_TABLE = 4;
    private static final int MTH_START_TABLE_COLGROUP = 5;
    private static final int MTH_START_TABLE_COL = 6;
    private static final int MTH_START_TABLE_SECTION = 7;
    private static final int MTH_START_TABLE_ROW = 8;
    private static final int MTH_START_TABLE_CELL = 9;
    private static final int MTH_START_BLOCK = 10;
    private static final int MTH_START_MARKER = 11;
    private static final int MTH_START_ROOT_INLINE = 12;
    private static final int MTH_START_INLINE = 13;
    private static final int MTH_START_TABLE_CAPTION = 14;
    private static final int MTH_END_TABLE_CAPTION = 18;
    private static final int MTH_END_INLINE = 19;
    private static final int MTH_END_ROOT_INLINE = 20;
    private static final int MTH_END_MARKER = 21;
    private static final int MTH_END_BLOCK = 22;
    private static final int MTH_END_TABLE_CELL = 23;
    private static final int MTH_END_TABLE_ROW = 24;
    private static final int MTH_END_TABLE_SECTION = 25;
    private static final int MTH_END_TABLE_COL = 26;
    private static final int MTH_END_TABLE_COLGROUP = 27;
    private static final int MTH_END_TABLE = 28;
    private static final int MTH_END_FLOW = 29;
    private static final int MTH_END_SPECIAL_FLOW = 30;
    private static final int MTH_END_DOCUMENT = 31;
    private static final int MTH_ADD_CONTENT = 41;
    private static final int MTH_HANDLE_PAGEBREAK = 42;
    private static final int MTH_START_PASSTHROUGH = 100;
    private static final int MTH_ADD_PASSTHROUGH_CONTENT = 101;
    private static final int MTH_END_PASSTHROUGH = 102;
    private Renderer renderer;

    public ChainingRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void startedDocument(PageContext pageContext) {
        this.addCall(new ChainingComponent.RecordedCall(1, pageContext));
    }

    @Override
    public void startedFlow(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(3, layoutContext));
    }

    @Override
    public void startedTable(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(4, layoutContext));
    }

    @Override
    public void startedTableColumnGroup(LayoutContext layoutContext) throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(5, layoutContext));
    }

    @Override
    public void startedTableColumn(LayoutContext layoutContext) throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(6, layoutContext));
    }

    @Override
    public void startedTableSection(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(7, layoutContext));
    }

    @Override
    public void startedTableRow(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(8, layoutContext));
    }

    @Override
    public void startedTableCell(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(9, layoutContext));
    }

    @Override
    public void startedBlock(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(10, layoutContext));
    }

    @Override
    public void startedMarker(LayoutContext layoutContext) throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(11, layoutContext));
    }

    @Override
    public void startedRootInline(LayoutContext layoutContext) throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(12, layoutContext));
    }

    @Override
    public void startedInline(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(13, layoutContext));
    }

    @Override
    public void addContent(LayoutContext layoutContext, ContentToken contentToken) {
        this.addCall(new ChainingComponent.RecordedCall(41, new Object[]{layoutContext, contentToken}));
    }

    @Override
    public void finishedInline() {
        this.addCall(new ChainingComponent.RecordedCall(19, null));
    }

    @Override
    public void finishedRootInline() throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(20, null));
    }

    @Override
    public void finishedMarker() throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(21, null));
    }

    @Override
    public void finishedBlock() {
        this.addCall(new ChainingComponent.RecordedCall(22, null));
    }

    @Override
    public void finishedTableCell() {
        this.addCall(new ChainingComponent.RecordedCall(23, null));
    }

    @Override
    public void finishedTableRow() {
        this.addCall(new ChainingComponent.RecordedCall(24, null));
    }

    @Override
    public void finishedTableSection() {
        this.addCall(new ChainingComponent.RecordedCall(25, null));
    }

    @Override
    public void finishedTableColumnGroup() throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(27, null));
    }

    @Override
    public void finishedTableColumn() throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(26, null));
    }

    @Override
    public void finishedTable() {
        this.addCall(new ChainingComponent.RecordedCall(28, null));
    }

    @Override
    public void finishedFlow() {
        this.addCall(new ChainingComponent.RecordedCall(29, null));
    }

    @Override
    public void finishedDocument() {
        this.addCall(new ChainingComponent.RecordedCall(31, null));
    }

    @Override
    public void handlePageBreak(PageContext pageContext) {
        this.addCall(new ChainingComponent.RecordedCall(42, pageContext));
    }

    @Override
    protected void invoke(Object object, int n, Object object2) throws Exception {
        Renderer renderer = (Renderer)object;
        switch (n) {
            case 1: {
                renderer.startedDocument((PageContext)object2);
                break;
            }
            case 3: {
                renderer.startedFlow((LayoutContext)object2);
                break;
            }
            case 4: {
                renderer.startedTable((LayoutContext)object2);
                break;
            }
            case 6: {
                renderer.startedTableColumn((LayoutContext)object2);
                break;
            }
            case 5: {
                renderer.startedTableColumnGroup((LayoutContext)object2);
                break;
            }
            case 7: {
                renderer.startedTableSection((LayoutContext)object2);
                break;
            }
            case 8: {
                renderer.startedTableRow((LayoutContext)object2);
                break;
            }
            case 9: {
                renderer.startedTableCell((LayoutContext)object2);
                break;
            }
            case 10: {
                renderer.startedBlock((LayoutContext)object2);
                break;
            }
            case 12: {
                renderer.startedRootInline((LayoutContext)object2);
                break;
            }
            case 11: {
                renderer.startedMarker((LayoutContext)object2);
                break;
            }
            case 13: {
                renderer.startedInline((LayoutContext)object2);
                break;
            }
            case 41: {
                Object[] objectArray = (Object[])object2;
                renderer.addContent((LayoutContext)objectArray[0], (ContentToken)objectArray[1]);
                break;
            }
            case 19: {
                renderer.finishedInline();
                break;
            }
            case 21: {
                renderer.finishedMarker();
                break;
            }
            case 23: {
                renderer.finishedTableCell();
                break;
            }
            case 24: {
                renderer.finishedTableRow();
                break;
            }
            case 25: {
                renderer.finishedTableSection();
                break;
            }
            case 27: {
                renderer.finishedTableColumnGroup();
                break;
            }
            case 26: {
                renderer.finishedTableColumn();
                break;
            }
            case 28: {
                renderer.finishedTable();
                break;
            }
            case 22: {
                renderer.finishedBlock();
                break;
            }
            case 20: {
                renderer.finishedRootInline();
                break;
            }
            case 29: {
                renderer.finishedFlow();
                break;
            }
            case 31: {
                renderer.finishedDocument();
                break;
            }
            case 42: {
                renderer.handlePageBreak((PageContext)object2);
                break;
            }
            case 100: {
                renderer.startedPassThrough((LayoutContext)object2);
            }
            case 101: {
                Object[] objectArray = (Object[])object2;
                renderer.addPassThroughContent((LayoutContext)objectArray[0], (ContentToken)objectArray[1]);
            }
            case 102: {
                renderer.finishedPassThrough();
            }
            case 14: {
                renderer.startedTableCaption((LayoutContext)object2);
            }
            case 18: {
                renderer.finishedTableCaption();
            }
            default: {
                throw new IllegalArgumentException("No such method!");
            }
        }
    }

    @Override
    public void startedPassThrough(LayoutContext layoutContext) {
        this.addCall(new ChainingComponent.RecordedCall(100, layoutContext));
    }

    @Override
    public void addPassThroughContent(LayoutContext layoutContext, ContentToken contentToken) {
        this.addCall(new ChainingComponent.RecordedCall(101, new Object[]{layoutContext, contentToken}));
    }

    @Override
    public void finishedPassThrough() {
        this.addCall(new ChainingComponent.RecordedCall(102, null));
    }

    @Override
    public void startedTableCaption(LayoutContext layoutContext) throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(14, layoutContext));
    }

    @Override
    public void finishedTableCaption() throws NormalizationException {
        this.addCall(new ChainingComponent.RecordedCall(18, null));
    }

    @Override
    public State saveState() throws StateException {
        return new ChainingRendererState(this.renderer.saveState());
    }

    private static class ChainingRendererState
    implements State {
        private State rendererState;

        private ChainingRendererState(State state) {
            this.rendererState = state;
        }

        @Override
        public StatefullComponent restore(LayoutProcess layoutProcess) throws StateException {
            Renderer renderer = (Renderer)this.rendererState.restore(layoutProcess);
            return new ChainingRenderer(renderer);
        }
    }
}

