/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadPool {
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 50, 10000L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    private ThreadPool() {
    }

    public static void execute(Runnable runnable) {
        executor.execute(runnable);
    }

    public static <T> void execute(FutureTask<T> futureTask) {
        executor.execute(futureTask);
    }

    public static <T> T process(Callable<T> task, long timeout) {
        block4: {
            if (task == null) {
                return null;
            }
            Future<T> future = executor.submit(task);
            try {
                return future.get(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                if (future.isCancelled()) break block4;
                future.cancel(true);
            }
        }
        return null;
    }
}

