/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.util;

public class Converter {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;

    public static byte[] getBytes(int number, int order) {
        int temp = number;
        byte[] b = new byte[4];
        if (order == 0) {
            for (int i = b.length - 1; i >= 0; --i) {
                b[i] = Long.valueOf(temp & 0xFF).byteValue();
                temp >>= 8;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                b[i] = Long.valueOf(temp & 0xFF).byteValue();
                temp >>= 8;
            }
        }
        return b;
    }

    public static byte[] getBytes(long number, int order) {
        long temp = number;
        byte[] b = new byte[8];
        if (order == 0) {
            for (int i = b.length - 1; i >= 0; --i) {
                b[i] = Long.valueOf(temp & 0xFFL).byteValue();
                temp >>= 8;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                b[i] = Long.valueOf(temp & 0xFFL).byteValue();
                temp >>= 8;
            }
        }
        return b;
    }

    public static byte[] getBytes(short number, int order) {
        int temp = number;
        byte[] b = new byte[8];
        if (order == 0) {
            for (int i = b.length - 1; i >= 0; --i) {
                b[i] = Long.valueOf(temp & 0xFF).byteValue();
                temp >>= 8;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                b[i] = Long.valueOf(temp & 0xFF).byteValue();
                temp >>= 8;
            }
        }
        return b;
    }

    public static long byteToLong(byte[] b, int order) {
        long s = 0L;
        long s0 = b[0] & 0xFF;
        long s1 = b[1] & 0xFF;
        long s2 = b[2] & 0xFF;
        long s3 = b[3] & 0xFF;
        long s4 = b[4] & 0xFF;
        long s5 = b[5] & 0xFF;
        long s6 = b[6] & 0xFF;
        long s7 = b[7] & 0xFF;
        if (order == 0) {
            s1 <<= 8;
            s2 <<= 16;
            s3 <<= 24;
            s4 <<= 32;
            s5 <<= 40;
            s6 <<= 48;
            s7 <<= 56;
        } else {
            s0 <<= 56;
            s1 <<= 48;
            s2 <<= 40;
            s3 <<= 32;
            s4 <<= 24;
            s5 <<= 16;
            s6 <<= 8;
        }
        s = s0 | s1 | s2 | s3 | s4 | s5 | s6 | s7;
        return s;
    }

    public static int byteToInt(byte[] b, int order) {
        int s = 0;
        int s0 = b[0] & 0xFF;
        int s1 = b[1] & 0xFF;
        int s2 = b[2] & 0xFF;
        int s3 = b[3] & 0xFF;
        if (order == 0) {
            s2 <<= 8;
            s1 <<= 16;
            s0 <<= 24;
        } else {
            s3 <<= 24;
            s2 <<= 16;
            s1 <<= 8;
        }
        s = s0 | s1 | s2 | s3;
        return s;
    }

    public static short byteToShort(byte[] b, int order) {
        short s = 0;
        short s0 = (short)(b[0] & 0xFF);
        short s1 = (short)(b[1] & 0xFF);
        if (order == 0) {
            s0 = (short)(s0 << 8);
            s = (short)(s0 | s1);
        } else {
            s1 = (short)(s1 << 8);
            s = (short)(s0 | s1);
        }
        return s;
    }

    public static char byteToHex(int i) {
        if (i >= 0 && i < 16) {
            return "0123456789ABCDEF".charAt(i);
        }
        return 'G';
    }
}

