/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.util;

public class CheckUtils {
    private CheckUtils() {
    }

    public static byte getCheckSum(byte[] bytes, int fromIndex, int len) {
        int btSum = 0;
        for (int nloop = fromIndex; nloop < fromIndex + len; ++nloop) {
            btSum = (byte)(btSum + bytes[nloop]);
        }
        return (byte)(~btSum + 1 & 0xFF);
    }

    public static boolean verifyChecksum(byte[] bytes) {
        if (CheckUtils.isEmpty(bytes)) {
            return false;
        }
        byte sum = CheckUtils.getCheckSum(bytes, 0, bytes.length - 1);
        return sum == bytes[bytes.length - 1];
    }

    public static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static boolean checkArrayLen(byte[] bytes, int length) {
        return bytes != null && bytes.length >= length;
    }

    public static boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static boolean isNotHexString(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        return !str.matches("^[A-Fa-f0-9]+$");
    }
}

