/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.util;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static byte[] mergeBytes(byte[] lBytes, byte[] rBytes) {
        if (lBytes == null) {
            if (rBytes == null) {
                return new byte[0];
            }
            return rBytes;
        }
        if (rBytes == null) {
            return lBytes;
        }
        byte[] mergeData = new byte[lBytes.length + rBytes.length];
        System.arraycopy(lBytes, 0, mergeData, 0, lBytes.length);
        System.arraycopy(rBytes, 0, mergeData, lBytes.length, rBytes.length);
        return mergeData;
    }

    public static String bytesToHexString(byte[] bytes, int fromIndex, int len) {
        if (fromIndex >= bytes.length) {
            return "";
        }
        if (fromIndex + len > bytes.length) {
            len = bytes.length - fromIndex;
        }
        int endIndex = fromIndex + len;
        StringBuilder strResult = new StringBuilder(String.format("%02X", bytes[fromIndex]));
        for (int i = fromIndex + 1; i < endIndex; ++i) {
            String strTemp = String.format(" %02X", bytes[i]);
            strResult.append(strTemp);
        }
        return strResult.toString();
    }

    public static byte[] hexStringToBytes(String hex) {
        boolean isOddNum;
        int len;
        if (hex == null || hex.length() == 0) {
            return new byte[0];
        }
        int hexLen = hex.length();
        int dataLen = len = hexLen >> 1;
        boolean bl = isOddNum = (hexLen & 1) != 0;
        if (isOddNum) {
            ++dataLen;
        }
        byte[] data = new byte[dataLen];
        for (int i = 0; i < len; ++i) {
            int pos = i << 1;
            data[i] = (byte)((Character.digit(hex.charAt(pos), 16) << 4) + Character.digit(hex.charAt(pos + 1), 16));
        }
        if (isOddNum) {
            data[len] = (byte)(Character.digit(hex.charAt(hexLen - 1), 16) << 4);
        }
        return data;
    }

    public static int spliceByteToInt(byte lByte, byte rByte) {
        int result = lByte;
        result = result << 8 | 0xFF & rByte;
        return result;
    }

    public static int byteArrayToInt(byte[] src, int fromIndex, int len) {
        return ArrayUtils.byteArrayToInt(src, fromIndex, len, true);
    }

    public static int byteArrayToInt(byte[] src, int fromIndex, int len, boolean bigEndian) {
        int interval = src.length - fromIndex;
        if (fromIndex < 0 || interval < 0 || interval < len || len > 4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = 0;
        int end = fromIndex + len;
        for (int i = fromIndex; i < end; ++i) {
            int offset = bigEndian ? end - 1 - i << 3 : i - fromIndex << 3;
            value |= (src[i] & 0xFF) << offset;
        }
        return value;
    }

    public static byte[] intToByteArray(int src) {
        int len = 4;
        byte[] dst = new byte[len];
        for (int i = 0; i < len; ++i) {
            dst[i] = (byte)(src >> (len - 1 - i) * 8);
        }
        return dst;
    }
}

