/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.process;

import com.payne.reader.base.Consumer;
import com.payne.reader.bean.config.AntennaCount;
import com.payne.reader.bean.config.CmdStatus;
import com.payne.reader.bean.config.FastTidType;
import com.payne.reader.bean.config.Freq;
import com.payne.reader.bean.config.MaskAction;
import com.payne.reader.bean.config.MaskId;
import com.payne.reader.bean.config.MaskTarget;
import com.payne.reader.bean.config.MemBank;
import com.payne.reader.bean.config.Region;
import com.payne.reader.bean.config.TagMeasOpt;
import com.payne.reader.bean.receive.AntConnectionDetector;
import com.payne.reader.bean.receive.Failure;
import com.payne.reader.bean.receive.FreqRegionResult;
import com.payne.reader.bean.receive.GpioOut;
import com.payne.reader.bean.receive.ImpinjFastTid;
import com.payne.reader.bean.receive.InventoryFailure;
import com.payne.reader.bean.receive.InventoryTag;
import com.payne.reader.bean.receive.InventoryTagEnd;
import com.payne.reader.bean.receive.MaskInfo;
import com.payne.reader.bean.receive.MatchInfo;
import com.payne.reader.bean.receive.OperationTag;
import com.payne.reader.bean.receive.OutputPower;
import com.payne.reader.bean.receive.ReaderIdentifier;
import com.payne.reader.bean.receive.ReaderStatus;
import com.payne.reader.bean.receive.ReaderTemperature;
import com.payne.reader.bean.receive.ReceiveData;
import com.payne.reader.bean.receive.RfLinkProfile;
import com.payne.reader.bean.receive.RfPortReturnLoss;
import com.payne.reader.bean.receive.Success;
import com.payne.reader.bean.receive.TempLabel2;
import com.payne.reader.bean.receive.Version;
import com.payne.reader.bean.receive.WorkAntenna;
import com.payne.reader.bean.send.FreqNormal;
import com.payne.reader.bean.send.FreqUserDefine;
import com.payne.reader.bean.send.GpioPin;
import com.payne.reader.bean.send.InventoryConfig;
import com.payne.reader.bean.send.OutputPowerConfig;
import com.payne.reader.bean.send.TempLabel2Config;
import com.payne.reader.communication.ConnectHandle;
import com.payne.reader.communication.DataPacket;
import com.payne.reader.communication.RequestInfo;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import com.payne.reader.util.ThreadPool;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class ResultProcess {
    private static final byte SET_ANTENNA_GROUP = 108;
    private static final byte GET_ANTENNA_GROUP = 109;
    private AntennaCount mAntennaCount;
    private final Map<Byte, Consumer> mSuccessMap;
    private final Map<Byte, Consumer> mFailureMap;
    public byte mAddress = (byte)-1;
    private ConnectHandle mConnectHandle;
    private byte[] mUnprocessedBytes = null;
    private final LinkedBlockingQueue<RequestInfo> mTransmitQueue;
    private long mTimeout = 2000L;
    private final AtomicBoolean mTransmitWaiting;
    private final AtomicBoolean mLoopInventory;
    private RequestInfo mRequestInfo;
    private RequestInfo mAfterSwitchGroupRequestInfo;
    private OutputPowerConfig mOutputPowerConfig;
    private InventoryConfig mInventoryConfig;
    private ScheduledExecutorService mScheduler;
    private ScheduledFuture<?> mScheduledFuture;
    private boolean mIsUserDefineRegion = false;
    private int mUserDefineFreqStart;
    public int mUserDefineFreqInterval = -1;
    private final AtomicInteger mCheckOperateTagCount;
    private final AtomicInteger mOperateTagCount;
    private Consumer<byte[]> mOriginalSendCallback;
    private Consumer<byte[]> mOriginalReceiveCallback;
    private Consumer<CmdStatus> mCmdStatusCallback;
    private Consumer<ReceiveData> mUndefinedResultCallback;
    private int mAntennaGroupId;
    private int mTrySetAntennaGroupId;
    private int mAntennaId;
    private int mTrySetAntennaId;
    private byte[] mLowEightAntennaPowers;
    private byte mTempLabel2Flag;
    private int mReadMemoryLen;
    private TagMeasOpt mTagMeasOpt;
    private boolean mEnableAsyncCallback;

    ResultProcess(AntennaCount antennaCount) {
        this.mAntennaCount = antennaCount;
        this.mEnableAsyncCallback = false;
        this.mTransmitQueue = new LinkedBlockingQueue(5);
        this.mTransmitWaiting = new AtomicBoolean(false);
        this.mLoopInventory = new AtomicBoolean(false);
        this.mCheckOperateTagCount = new AtomicInteger(0);
        this.mOperateTagCount = new AtomicInteger(0);
        this.mSuccessMap = new ConcurrentHashMap<Byte, Consumer>();
        this.mFailureMap = new ConcurrentHashMap<Byte, Consumer>();
    }

    public void switchAntennaCount(AntennaCount antennaCount) {
        this.mAntennaCount = antennaCount;
    }

    public AntennaCount getAntennaCount() {
        return this.mAntennaCount;
    }

    boolean connect(ConnectHandle handle, boolean enableAsyncCallback) {
        this.disconnect();
        this.mConnectHandle = handle;
        this.mEnableAsyncCallback = enableAsyncCallback;
        this.mConnectHandle.onReceive(new Consumer<byte[]>(){

            @Override
            public void accept(byte[] bytes) throws Exception {
                ResultProcess.this.processReceive(bytes);
            }
        });
        return handle.onConnect();
    }

    boolean isConnected() {
        return this.mConnectHandle != null && this.mConnectHandle.isConnected();
    }

    final void setResultCallback(byte cmd, Consumer<? extends Success> onSuccess, Consumer<? extends Failure> onError) {
        if (onSuccess != null) {
            this.mSuccessMap.put(cmd, onSuccess);
        } else {
            this.mSuccessMap.remove(cmd);
        }
        if (onError != null) {
            this.mFailureMap.put(cmd, onError);
        } else {
            this.mFailureMap.remove(cmd);
        }
    }

    final void setTimeout(long timeoutMillis) {
        this.mTimeout = timeoutMillis;
    }

    final void setTempLabel2Config(TempLabel2Config config) {
        this.mTempLabel2Flag = config.getTempLabel2Flag();
        this.mReadMemoryLen = config.getReadMemoryLen();
        this.mTagMeasOpt = config.getTagMeasOpt();
    }

    final void setFreqNormal() {
        this.mIsUserDefineRegion = false;
    }

    final void setFreqUserDefine(int userDefineFreqStart, int userDefineFreqInterval) {
        this.mIsUserDefineRegion = true;
        this.mUserDefineFreqStart = userDefineFreqStart;
        this.mUserDefineFreqInterval = userDefineFreqInterval;
    }

    void setOutputPower(OutputPowerConfig config) {
        this.mOutputPowerConfig = config;
        DataPacket packet = new DataPacket(this.mAddress, 118, config.getPowers());
        RequestInfo requestInfo = new RequestInfo(packet);
        if (this.mAntennaGroupId != 0) {
            this.setAntennaGroup(0, requestInfo);
        } else {
            this.addRequest(requestInfo);
        }
    }

    void setInventoryConfig(InventoryConfig config) {
        this.mInventoryConfig = config;
    }

    void startInventory(boolean loop) {
        if (this.mInventoryConfig == null) {
            throw new RuntimeException("Please call setInventoryConfig first");
        }
        this.mLoopInventory.set(loop);
        byte cmd = this.mInventoryConfig.getCmd();
        DataPacket packet = new DataPacket(this.mAddress, cmd, this.mInventoryConfig.getInventoryParams());
        RequestInfo requestInfo = new RequestInfo(packet);
        if (cmd == -118 && this.mAntennaGroupId != 0) {
            this.setAntennaGroup(0, requestInfo);
        } else {
            this.addRequest(requestInfo);
        }
    }

    void stopInventory() {
        this.mLoopInventory.set(false);
    }

    void setAntennaGroup(int groupId, RequestInfo afterRequestInfo) {
        this.mTrySetAntennaGroupId = groupId;
        this.mAfterSwitchGroupRequestInfo = afterRequestInfo;
        byte[] btAryData = new byte[]{(byte)groupId};
        DataPacket packet = new DataPacket(this.mAddress, 108, btAryData);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.addRequest(requestInfo);
    }

    void setTryAntennaId(int tryAntennaId) {
        this.mTrySetAntennaId = tryAntennaId;
    }

    void getAntennaGroup(RequestInfo afterRequestInfo) {
        this.mAfterSwitchGroupRequestInfo = afterRequestInfo;
        DataPacket packet = new DataPacket(this.mAddress, 109);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.addRequest(requestInfo);
    }

    int getAntennaGroupId() {
        return this.mAntennaGroupId;
    }

    int getCacheAntennaId() {
        return this.mAntennaId;
    }

    void addRequest(RequestInfo requestInfo) {
        try {
            if (requestInfo == null) {
                throw new RuntimeException("RequestConfig is null");
            }
            if (this.mConnectHandle == null) {
                throw new RuntimeException("Please connect the reader first");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        boolean success = this.mTransmitQueue.offer(requestInfo);
        if (!success) {
            DataPacket packet = requestInfo.getDataPacket();
            byte cmd = packet.getCmd();
            this.resultFailure(cmd, (byte)-80);
            this.sendRequest();
        } else {
            this.sendRequest();
        }
    }

    private void sendRequest() {
        if (this.mTransmitWaiting.compareAndSet(false, true)) {
            this.mRequestInfo = this.mTransmitQueue.poll();
            if (this.mRequestInfo == null) {
                this.mTransmitWaiting.set(false);
                return;
            }
            DataPacket packet = this.mRequestInfo.getDataPacket();
            final byte[] sendData = packet.getData();
            if (this.mOriginalSendCallback != null) {
                try {
                    this.mOriginalSendCallback.accept(sendData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mConnectHandle != null) {
                if (this.mEnableAsyncCallback) {
                    ThreadPool.execute(new Runnable(){

                        @Override
                        public void run() {
                            ResultProcess.this.mConnectHandle.onSend(sendData);
                        }
                    });
                } else {
                    this.mConnectHandle.onSend(sendData);
                }
            }
            this.startTiming(this.mRequestInfo);
        }
    }

    private void processReceive(byte[] bytes) {
        byte[] mergeBytes = bytes;
        if (this.mUnprocessedBytes != null) {
            mergeBytes = ArrayUtils.mergeBytes(this.mUnprocessedBytes, bytes);
        }
        int minOnePacketDataLen = 5;
        int totalLen = mergeBytes.length;
        int index = 0;
        while (index < totalLen) {
            if (mergeBytes[index] == -96) {
                if (index + minOnePacketDataLen > totalLen) {
                    this.saveUnprocessedData(mergeBytes, index);
                    return;
                }
                int dataLen = mergeBytes[index + 1] & 0xFF;
                int onePacketDataLen = dataLen + 2;
                if (index + onePacketDataLen > totalLen) {
                    this.saveUnprocessedData(mergeBytes, index);
                    return;
                }
                byte[] extractData = new byte[onePacketDataLen];
                System.arraycopy(mergeBytes, index, extractData, 0, onePacketDataLen);
                this.analyzeExtractData(extractData);
                index += onePacketDataLen;
                continue;
            }
            ++index;
        }
        this.mUnprocessedBytes = null;
    }

    private void saveUnprocessedData(byte[] mergeBytes, int index) {
        if (index > 0) {
            this.mUnprocessedBytes = new byte[mergeBytes.length - index];
            System.arraycopy(mergeBytes, index, this.mUnprocessedBytes, 0, this.mUnprocessedBytes.length);
        } else {
            this.mUnprocessedBytes = mergeBytes;
        }
    }

    private void analyzeExtractData(byte[] extractData) {
        if (!CheckUtils.verifyChecksum(extractData)) {
            System.out.println("Packet checksum check failed! ");
            return;
        }
        final DataPacket protocol = new DataPacket(extractData);
        this.mAddress = protocol.getAddress();
        byte requestCmd = 0;
        if (this.mRequestInfo != null) {
            DataPacket packet = this.mRequestInfo.getDataPacket();
            requestCmd = packet.getCmd();
        }
        if (this.mOriginalReceiveCallback != null) {
            try {
                this.mOriginalReceiveCallback.accept(extractData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mEnableAsyncCallback) {
            ThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    ResultProcess.this.analyzeData(protocol);
                }
            });
        } else {
            this.analyzeData(protocol);
        }
        this.checkRequestAccepted(requestCmd, protocol);
    }

    private void checkRequestAccepted(byte requestCmd, DataPacket receivePacket) {
        byte receiveCmd = receivePacket.getCmd();
        if (requestCmd == receiveCmd) {
            boolean isReceived;
            this.cancelTiming();
            if (receiveCmd == -118) {
                int len = receivePacket.getCoreDataLen();
                isReceived = len <= 2 || len == 7;
            } else if (receiveCmd == -117) {
                int len = receivePacket.getCoreDataLen();
                isReceived = len <= 1 || len == 7;
            } else if (receiveCmd == -127 | receiveCmd == -126 | receiveCmd == -108 | receiveCmd == -125 | receiveCmd == -124) {
                int len = receivePacket.getCoreDataLen();
                if (len == 1) {
                    isReceived = true;
                } else {
                    try {
                        byte[] data = receivePacket.getData();
                        int fromIndex = DataPacket.fromIndex();
                        int tagCount = ((data[fromIndex] & 0xFF) << 8) + (data[fromIndex + 1] & 0xFF);
                        this.mCheckOperateTagCount.incrementAndGet();
                        isReceived = this.mCheckOperateTagCount.compareAndSet(tagCount, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        isReceived = false;
                    }
                }
            } else {
                isReceived = true;
            }
            this.checkLoopInventory(requestCmd, isReceived);
            if (isReceived) {
                this.mTransmitWaiting.set(false);
                this.sendRequest();
            } else {
                this.startTiming(this.mRequestInfo);
            }
        } else {
            System.out.println("send cmd:" + String.format("%02X", requestCmd) + ", receive cmd:" + String.format("%02X", receiveCmd));
        }
    }

    private void checkLoopInventory(byte cmd, boolean isReceived) {
        if (isReceived && this.mLoopInventory.get() && this.mInventoryConfig != null) {
            if (cmd == -128 || cmd == -117) {
                byte requestCmd = this.mRequestInfo.getDataPacket().getCmd();
                if (requestCmd == cmd) {
                    this.addRequest(this.mRequestInfo);
                } else {
                    DataPacket packet = new DataPacket(this.mAddress, this.mInventoryConfig.getCmd(), this.mInventoryConfig.getInventoryParams());
                    RequestInfo requestInfo = new RequestInfo(packet);
                    this.addRequest(requestInfo);
                }
            } else if (cmd == -118) {
                if (this.mAntennaCount == AntennaCount.SIXTEEN_CHANNELS) {
                    int newAntennaGroupId;
                    DataPacket packet = (newAntennaGroupId = ++this.mAntennaGroupId % 2) == 0 ? new DataPacket(this.mAddress, this.mInventoryConfig.getCmd(), this.mInventoryConfig.getInventoryParams()) : new DataPacket(this.mAddress, this.mInventoryConfig.getCmd(), this.mInventoryConfig.getHighEightAntennaInventoryParams());
                    RequestInfo requestInfo = new RequestInfo(packet);
                    this.setAntennaGroup(newAntennaGroupId, requestInfo);
                } else {
                    byte requestCmd = this.mRequestInfo.getDataPacket().getCmd();
                    if (requestCmd == cmd) {
                        this.addRequest(this.mRequestInfo);
                    } else {
                        DataPacket packet = new DataPacket(this.mAddress, this.mInventoryConfig.getCmd(), this.mInventoryConfig.getInventoryParams());
                        RequestInfo requestInfo = new RequestInfo(packet);
                        this.addRequest(requestInfo);
                    }
                }
            }
        }
    }

    protected void analyzeData(DataPacket protocol) {
        switch (protocol.getCmd()) {
            case 112: {
                this.processReset(protocol);
                break;
            }
            case 113: {
                this.processSetBaudRate(protocol);
                break;
            }
            case 114: {
                this.processGetFirmwareVersion(protocol);
                break;
            }
            case 115: {
                this.processSetReaderAddress(protocol);
                break;
            }
            case 116: {
                this.processSetWorkAntenna(protocol);
                break;
            }
            case 117: {
                this.processGetWorkAntenna(protocol);
                break;
            }
            case 118: {
                this.processSetOutputPower(protocol);
                break;
            }
            case -105: 
            case 119: {
                this.processGetOutputPower(protocol);
                break;
            }
            case 120: {
                this.processSetFrequencyRegion(protocol);
                break;
            }
            case 121: {
                this.processGetFrequencyRegion(protocol);
                break;
            }
            case 122: {
                this.processSetBeeperMode(protocol);
                break;
            }
            case 123: {
                this.processGetReaderTemperature(protocol);
                break;
            }
            case 96: {
                this.processReadGpioValue(protocol);
                break;
            }
            case 97: {
                this.processWriteGpioValue(protocol);
                break;
            }
            case 98: {
                this.processSetAntConnectionDetector(protocol);
                break;
            }
            case 99: {
                this.processGetAntConnectionDetector(protocol);
                break;
            }
            case 102: {
                this.processSetTemporaryOutputPower(protocol);
                break;
            }
            case 103: {
                this.processSetReaderIdentifier(protocol);
                break;
            }
            case 104: {
                this.processGetReaderIdentifier(protocol);
                break;
            }
            case 105: {
                this.processSetRfLinkProfile(protocol);
                break;
            }
            case 106: {
                this.processGetRfLinkProfile(protocol);
                break;
            }
            case 126: {
                this.processGetRfPortReturnLoss(protocol);
                break;
            }
            case 108: {
                this.processSetAntennaGroup(protocol);
                break;
            }
            case 109: {
                this.processGetAntennaGroup(protocol);
                break;
            }
            case -128: {
                this.processInventory(protocol);
                break;
            }
            case -118: {
                this.processFastSwitchInventory(protocol);
                break;
            }
            case -117: {
                this.processCustomizedSessionTargetInventory(protocol);
                break;
            }
            case -127: {
                this.processReadTag(protocol);
                break;
            }
            case -126: {
                this.processWriteTag(protocol);
                break;
            }
            case -125: {
                this.processLockTag(protocol);
                break;
            }
            case -124: {
                this.processKillTag(protocol);
                break;
            }
            case -116: {
                this.processSetImpinjFastTid(protocol);
                break;
            }
            case -115: {
                this.processSetAndSaveImpinjFastTid(protocol);
                break;
            }
            case -114: {
                this.processGetImpinjFastTid(protocol);
                break;
            }
            case -108: {
                this.processBlockTag(protocol);
                break;
            }
            case -123: {
                this.processSetAccessEpcMatch(protocol);
                break;
            }
            case -122: {
                this.processGetAccessEpcMatch(protocol);
                break;
            }
            case -104: {
                this.processTagMask(protocol);
                break;
            }
            case -95: {
                this.processQueryReaderStatus(protocol);
                break;
            }
            case -96: {
                this.processSetReaderStatus(protocol);
                break;
            }
            case -3: {
                this.processTempLabel2Command(protocol);
                break;
            }
            default: {
                this.processUndefined(protocol);
            }
        }
    }

    private void processReset(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        boolean hasResultCode = protocol.getCoreDataLen() == 1;
        byte resultCode = protocol.getData()[DataPacket.fromIndex()];
        if (hasResultCode) {
            this.resultFailure(cmd, resultCode);
        }
    }

    private boolean processSet(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        boolean hasResultCode = protocol.getCoreDataLen() == 1;
        byte resultCode = protocol.getData()[DataPacket.fromIndex()];
        if (hasResultCode) {
            if (resultCode == 16) {
                if (cmd == 116) {
                    this.mAntennaId = this.mTrySetAntennaId;
                }
                Success success = new Success();
                success.setCmd(cmd);
                this.resultSuccess(cmd, success);
                return true;
            }
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
        return false;
    }

    private void processSetBaudRate(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetFirmwareVersion(DataPacket protocol) {
        int dataLen = protocol.getCoreDataLen();
        byte cmd = protocol.getCmd();
        if (dataLen == 2) {
            byte major = protocol.getData()[DataPacket.fromIndex()];
            byte minor = protocol.getData()[DataPacket.fromIndex() + 1];
            String strVersion = (major & 0xFF) + "." + (minor & 0xFF);
            Version fVersion = new Version();
            fVersion.setCmd(cmd);
            fVersion.setVersion(strVersion);
            this.resultSuccess(cmd, fVersion);
        } else if (dataLen == 1) {
            byte resultCode = protocol.getData()[DataPacket.fromIndex()];
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetReaderAddress(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processSetWorkAntenna(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetWorkAntenna(DataPacket protocol) {
        int dataLen = protocol.getCoreDataLen();
        byte cmd = protocol.getCmd();
        if (dataLen == 1) {
            byte resultCode = protocol.getData()[DataPacket.fromIndex()];
            if (resultCode == 0 || resultCode == 1 || resultCode == 2 || resultCode == 3) {
                this.mAntennaId = (resultCode & 0xFF) + (this.mAntennaGroupId << 3);
                WorkAntenna antenna = new WorkAntenna();
                antenna.setCmd(cmd);
                antenna.setWorkAntenna(this.mAntennaId);
                this.resultSuccess(cmd, antenna);
            } else {
                this.resultFailure(cmd, resultCode);
            }
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetOutputPower(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        boolean hasResultCode = protocol.getCoreDataLen() == 1;
        byte resultCode = protocol.getData()[DataPacket.fromIndex()];
        if (hasResultCode) {
            if (resultCode == 16) {
                if (this.mAntennaGroupId == 0 && this.mAntennaCount == AntennaCount.SIXTEEN_CHANNELS) {
                    if (this.mOutputPowerConfig != null) {
                        DataPacket packet = new DataPacket(this.mAddress, 118, this.mOutputPowerConfig.getHighEightAntennaPowers());
                        RequestInfo requestInfo = new RequestInfo(packet);
                        this.setAntennaGroup(1, requestInfo);
                    }
                } else {
                    Success success = new Success();
                    success.setCmd(cmd);
                    this.resultSuccess(cmd, success);
                }
            } else {
                this.resultFailure(cmd, resultCode);
            }
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processGetOutputPower(DataPacket protocol) {
        int dataLen = protocol.getCoreDataLen();
        byte cmd = protocol.getCmd();
        if (dataLen == 1 || dataLen == 4) {
            byte[] outputPowers = new byte[dataLen];
            System.arraycopy(protocol.getData(), DataPacket.fromIndex(), outputPowers, 0, dataLen);
            OutputPower power = new OutputPower();
            power.setCmd(cmd);
            power.setOutputPower(outputPowers);
            this.resultSuccess(cmd, power);
        } else if (dataLen == 8) {
            byte[] outputPowers = new byte[dataLen];
            System.arraycopy(protocol.getData(), DataPacket.fromIndex(), outputPowers, 0, dataLen);
            if (this.mAntennaCount == AntennaCount.SIXTEEN_CHANNELS && this.mAntennaGroupId == 0) {
                this.mLowEightAntennaPowers = outputPowers;
                this.setAntennaGroup(1, this.mRequestInfo);
            } else {
                OutputPower power = new OutputPower();
                power.setCmd(cmd);
                if (this.mLowEightAntennaPowers != null) {
                    byte[] newPowers = new byte[this.mLowEightAntennaPowers.length + outputPowers.length];
                    System.arraycopy(this.mLowEightAntennaPowers, 0, newPowers, 0, this.mLowEightAntennaPowers.length);
                    System.arraycopy(outputPowers, 0, newPowers, this.mLowEightAntennaPowers.length, outputPowers.length);
                    power.setOutputPower(newPowers);
                    this.mLowEightAntennaPowers = null;
                } else {
                    power.setOutputPower(outputPowers);
                }
                this.resultSuccess(cmd, power);
            }
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetFrequencyRegion(DataPacket protocol) {
        boolean success = this.processSet(protocol);
        if (!success) {
            this.mUserDefineFreqInterval = -1;
        }
    }

    private void processGetFrequencyRegion(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 3) {
            this.mIsUserDefineRegion = false;
            this.mUserDefineFreqInterval = 0;
            FreqNormal freqNormal = new FreqNormal.Builder().setRegion(Region.valueOf(data[fromIndex])).setFreqStart(Freq.valueOf(data[fromIndex + 1])).setFreqEnd(Freq.valueOf(data[fromIndex + 2])).build();
            FreqRegionResult freqRegionResult = new FreqRegionResult();
            freqRegionResult.setCmd(cmd);
            freqRegionResult.setUserDefine(false);
            freqRegionResult.setFreqNormal(freqNormal);
            this.resultSuccess(cmd, freqRegionResult);
        } else if (dataLen == 6) {
            this.mIsUserDefineRegion = true;
            this.mUserDefineFreqInterval = (data[fromIndex + 1] & 0xFF) * 10;
            this.mUserDefineFreqStart = ((data[fromIndex + 3] & 0xFF) << 16) + ((data[fromIndex + 4] & 0xFF) << 8) + (data[fromIndex + 5] & 0xFF);
            FreqUserDefine freqUserDefine = new FreqUserDefine.Builder().setFreqStart(this.mUserDefineFreqStart).setFreqInterval(this.mUserDefineFreqInterval).setFreqQuantity(data[fromIndex + 2]).build();
            FreqRegionResult freqRegionResult = new FreqRegionResult();
            freqRegionResult.setCmd(cmd);
            freqRegionResult.setUserDefine(true);
            freqRegionResult.setFreqUserDefine(freqUserDefine);
            this.resultSuccess(cmd, freqRegionResult);
        } else if (dataLen == 1) {
            this.resultFailure(cmd, data[fromIndex]);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetBeeperMode(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetReaderTemperature(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 2) {
            boolean isAboveZero = data[fromIndex] == 1;
            byte temperature = data[fromIndex + 1];
            if (!isAboveZero) {
                temperature = -temperature;
            }
            ReaderTemperature readerTemperature = new ReaderTemperature();
            readerTemperature.setCmd(cmd);
            readerTemperature.setTemperature(temperature);
            this.resultSuccess(cmd, readerTemperature);
        } else if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processReadGpioValue(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 2) {
            GpioPin pin1 = new GpioPin();
            pin1.setId(1);
            pin1.setHigh(data[fromIndex] == 1);
            pin1.setOutput(true);
            GpioPin pin2 = new GpioPin();
            pin2.setId(2);
            pin2.setHigh(data[fromIndex + 1] == 1);
            pin2.setOutput(true);
            GpioOut gpioOut = new GpioOut();
            gpioOut.setCmd(cmd);
            gpioOut.setGpios(new GpioPin[]{pin1, pin2});
            this.resultSuccess(cmd, gpioOut);
        } else if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processWriteGpioValue(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processSetAntConnectionDetector(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetAntConnectionDetector(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        if (dataLen == 1) {
            byte antValue = protocol.getData()[DataPacket.fromIndex()];
            AntConnectionDetector detector = new AntConnectionDetector();
            detector.setCmd(cmd);
            detector.setClose(antValue == 0);
            detector.setAntDetector(antValue);
            this.resultSuccess(cmd, detector);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetTemporaryOutputPower(DataPacket protocol) {
        this.processSetOutputPower(protocol);
    }

    private void processSetReaderIdentifier(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetReaderIdentifier(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 12) {
            byte[] identifier = new byte[12];
            System.arraycopy(data, fromIndex, identifier, 0, dataLen);
            String strIdentifier = ArrayUtils.bytesToHexString(identifier, 0, identifier.length);
            ReaderIdentifier readerIdentifier = new ReaderIdentifier();
            readerIdentifier.setCmd(cmd);
            readerIdentifier.setIdentifier(strIdentifier);
            this.resultSuccess(cmd, readerIdentifier);
        } else if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetRfLinkProfile(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetRfLinkProfile(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        if (dataLen == 1) {
            int fromIndex;
            byte[] data = protocol.getData();
            byte resultCode = data[fromIndex = DataPacket.fromIndex()];
            if ((resultCode & 0xFF) >= 208 && (resultCode & 0xFF) <= 211) {
                RfLinkProfile profile = new RfLinkProfile();
                profile.setCmd(cmd);
                profile.setLinkProfile(resultCode);
                this.resultSuccess(cmd, profile);
            } else {
                this.resultFailure(cmd, resultCode);
            }
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processGetRfPortReturnLoss(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        if (dataLen == 1) {
            byte returnLoss = protocol.getData()[DataPacket.fromIndex()];
            RfPortReturnLoss rfPortReturnLoss = new RfPortReturnLoss();
            rfPortReturnLoss.setCmd(cmd);
            rfPortReturnLoss.setReturnLoss(returnLoss);
            this.resultSuccess(cmd, rfPortReturnLoss);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetAntennaGroup(DataPacket protocol) {
        boolean hasResultCode = protocol.getCoreDataLen() == 1;
        byte resultCode = protocol.getData()[DataPacket.fromIndex()];
        if (hasResultCode && resultCode == 16) {
            this.mAntennaGroupId = this.mTrySetAntennaGroupId;
            if (this.mAfterSwitchGroupRequestInfo != null) {
                this.addRequest(this.mAfterSwitchGroupRequestInfo);
                this.mAfterSwitchGroupRequestInfo = null;
            }
        } else if (this.mAfterSwitchGroupRequestInfo != null) {
            DataPacket packet = this.mAfterSwitchGroupRequestInfo.getDataPacket();
            byte afterCmd = packet.getCmd();
            byte btResCode = hasResultCode ? resultCode : (byte)88;
            this.resultFailure(afterCmd, btResCode);
            this.mAfterSwitchGroupRequestInfo = null;
        }
    }

    private void processGetAntennaGroup(DataPacket protocol) {
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            this.mAntennaGroupId = data[fromIndex] & 0xFF;
            if (this.mAfterSwitchGroupRequestInfo != null) {
                this.addRequest(this.mAfterSwitchGroupRequestInfo);
                this.mAfterSwitchGroupRequestInfo = null;
            }
        } else if (this.mAfterSwitchGroupRequestInfo != null) {
            DataPacket packet = this.mAfterSwitchGroupRequestInfo.getDataPacket();
            byte afterCmd = packet.getCmd();
            byte btResCode = 88;
            this.resultFailure(afterCmd, btResCode);
            this.mAfterSwitchGroupRequestInfo = null;
        }
    }

    private void processInventory(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 9) {
            Consumer<InventoryTagEnd> successConsumer;
            if (this.mInventoryConfig != null && (successConsumer = this.mInventoryConfig.getOnSuccessEnd()) != null) {
                try {
                    int currentAnt = data[fromIndex] & 255 + (this.mAntennaGroupId > 0 ? 8 : 0);
                    int tagCount = ((data[fromIndex + 1] & 0xFF) << 8) + (data[fromIndex + 2] & 0xFF);
                    int readRate = ((data[fromIndex + 3] & 0xFF) << 8) + (data[fromIndex + 4] & 0xFF);
                    int totalRead = ((data[fromIndex + 5] & 0xFF) << 24) + ((data[fromIndex + 6] & 0xFF) << 16) + ((data[fromIndex + 7] & 0xFF) << 8) + (data[fromIndex + 8] & 0xFF);
                    InventoryTagEnd tagEnd = new InventoryTagEnd();
                    tagEnd.setCurrentAnt(currentAnt);
                    tagEnd.setReadRate(readRate);
                    tagEnd.setTotalRead(totalRead);
                    tagEnd.setTagCount(tagCount);
                    successConsumer.accept(tagEnd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mCmdStatusCallback != null) {
                try {
                    this.mCmdStatusCallback.accept(new CmdStatus(cmd, 16, this.mAntennaId));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            this.resultFailure(cmd, resultCode);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processFastSwitchInventory(DataPacket protocol) {
        Consumer<InventoryTag> successConsumer;
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        int endIndex = fromIndex + dataLen;
        if (dataLen == 1) {
            byte errorCode = data[fromIndex];
            this.resultFailure(cmd, errorCode);
        } else if (dataLen == 2) {
            int antId = data[fromIndex] & 0xFF;
            byte errorCode = data[fromIndex + 1];
            this.resultFailure(cmd, errorCode, antId);
        } else if (dataLen == 7) {
            Consumer<InventoryTagEnd> successConsumer2;
            if (this.mInventoryConfig != null && (successConsumer2 = this.mInventoryConfig.getOnSuccessEnd()) != null) {
                try {
                    int nSwitchTotal = ((data[fromIndex] & 0xFF) << 16) + ((data[fromIndex + 1] & 0xFF) << 8) + (data[fromIndex + 2] & 0xFF);
                    int nSwitchTime = ((data[fromIndex + 3] & 0xFF) << 24) + ((data[fromIndex + 4] & 0xFF) << 16) + ((data[fromIndex + 5] & 0xFF) << 8) + (data[fromIndex + 6] & 0xFF);
                    InventoryTagEnd inventoryTagEnd = new InventoryTagEnd();
                    inventoryTagEnd.setCmd(cmd);
                    inventoryTagEnd.setTotalRead(nSwitchTotal);
                    if (nSwitchTime > 0) {
                        inventoryTagEnd.setReadRate(nSwitchTotal / nSwitchTime);
                    } else {
                        inventoryTagEnd.setReadRate(0);
                    }
                    successConsumer2.accept(inventoryTagEnd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mCmdStatusCallback != null) {
                try {
                    this.mCmdStatusCallback.accept(new CmdStatus(cmd, 16, this.mAntennaId));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mAntennaId = 7 + (this.mAntennaGroupId << 3);
        } else if (this.mInventoryConfig != null && (successConsumer = this.mInventoryConfig.getOnSuccess()) != null) {
            try {
                boolean isEnablePhase = this.mInventoryConfig.isEnablePhase();
                int offset = isEnablePhase ? 3 : 1;
                int nEpcLength = dataLen - 3 - offset;
                String strEpc = ArrayUtils.bytesToHexString(data, fromIndex + 3, nEpcLength);
                String strPc = ArrayUtils.bytesToHexString(data, fromIndex + 1, 2);
                int rssi = data[endIndex - offset] & 0x7F;
                int nPhase = 0;
                if (isEnablePhase) {
                    nPhase = ArrayUtils.spliceByteToInt(data[endIndex - 2], data[endIndex - 1]);
                }
                byte btTemp = data[fromIndex];
                int antId = (btTemp & 3) + ((data[endIndex - offset] & 0xFF) >> 7) * 4 + (this.mAntennaGroupId > 0 ? 8 : 0);
                int freqQuantity = (btTemp & 0xFF) >> 2;
                String strFreq = this.getFreqString(freqQuantity);
                InventoryTag inventoryTag = new InventoryTag();
                inventoryTag.setCmd(cmd);
                inventoryTag.setPc(strPc);
                inventoryTag.setEpc(strEpc);
                inventoryTag.setRssi(rssi - 129);
                inventoryTag.setPhase(nPhase);
                inventoryTag.setFreq(strFreq);
                inventoryTag.setAntId(antId);
                successConsumer.accept(inventoryTag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void processCustomizedSessionTargetInventory(DataPacket protocol) {
        Consumer<InventoryTag> successConsumer;
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        int endIndex = fromIndex + dataLen;
        if (dataLen == 1) {
            byte errorCode = data[fromIndex];
            this.resultFailure(cmd, errorCode);
        } else if (dataLen == 7) {
            Consumer<InventoryTagEnd> successConsumer2;
            if (this.mInventoryConfig != null && (successConsumer2 = this.mInventoryConfig.getOnSuccessEnd()) != null) {
                try {
                    int currentAnt = data[fromIndex] & 255 + (this.mAntennaGroupId > 0 ? 8 : 0);
                    int readRate = ((data[fromIndex + 1] & 0xFF) << 8) + (data[fromIndex + 2] & 0xFF);
                    int totalRead = ((data[fromIndex + 3] & 0xFF) << 24) + ((data[fromIndex + 4] & 0xFF) << 16) + ((data[fromIndex + 5] & 0xFF) << 8) + (data[fromIndex + 6] & 0xFF);
                    InventoryTagEnd inventoryTagEnd = new InventoryTagEnd();
                    inventoryTagEnd.setCmd(cmd);
                    inventoryTagEnd.setCurrentAnt(currentAnt);
                    inventoryTagEnd.setReadRate(readRate);
                    inventoryTagEnd.setTotalRead(totalRead);
                    successConsumer2.accept(inventoryTagEnd);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.mCmdStatusCallback != null) {
                try {
                    this.mCmdStatusCallback.accept(new CmdStatus(cmd, 16, this.mAntennaId));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (this.mInventoryConfig != null && (successConsumer = this.mInventoryConfig.getOnSuccess()) != null) {
            try {
                boolean isEnablePhase = this.mInventoryConfig.isEnablePhase();
                int offset = isEnablePhase ? 3 : 1;
                int nEpcLength = dataLen - 3 - offset;
                String strEpc = "";
                if (nEpcLength != 0) {
                    strEpc = ArrayUtils.bytesToHexString(data, fromIndex + 3, nEpcLength);
                }
                String strPc = ArrayUtils.bytesToHexString(data, fromIndex + 1, 2);
                int rssi = data[endIndex - offset] & 0x7F;
                int nPhase = 0;
                if (isEnablePhase) {
                    nPhase = ArrayUtils.spliceByteToInt(data[endIndex - 2], data[endIndex - 1]);
                }
                byte btTemp = data[fromIndex];
                int antId = (btTemp & 3) + ((data[endIndex - offset] & 0xFF) >> 7) * 4 + (this.mAntennaGroupId > 0 ? 8 : 0);
                int freqQuantity = (btTemp & 0xFF) >> 2;
                String strFreq = this.getFreqString(freqQuantity);
                InventoryTag inventoryTag = new InventoryTag();
                inventoryTag.setCmd(cmd);
                inventoryTag.setPc(strPc);
                inventoryTag.setEpc(strEpc);
                inventoryTag.setRssi(rssi - 129);
                inventoryTag.setPhase(nPhase);
                inventoryTag.setFreq(strFreq);
                inventoryTag.setAntId(antId);
                successConsumer.accept(inventoryTag);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void processReadTag(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            this.resultFailure(cmd, resultCode);
        } else {
            int tagCount = ((data[fromIndex] & 0xFF) << 8) + (data[fromIndex + 1] & 0xFF);
            int nDataLen = data[fromIndex + dataLen - 3] & 0xFF;
            int nEpcLen = (data[fromIndex + 2] & 0xFF) - nDataLen - 4;
            String strPc = ArrayUtils.bytesToHexString(data, fromIndex + 3, 2);
            String strEpc = ArrayUtils.bytesToHexString(data, fromIndex + 5, nEpcLen);
            String strCrc = ArrayUtils.bytesToHexString(data, fromIndex + 5 + nEpcLen, 2);
            String strData = ArrayUtils.bytesToHexString(data, fromIndex + 7 + nEpcLen, nDataLen);
            byte btTemp = data[fromIndex + dataLen - 2];
            byte btAntId = (byte)((btTemp & 3) + ((data[fromIndex + dataLen - 1] & 0xFF) >> 7) * 4 + (this.mAntennaGroupId > 0 ? 8 : 0));
            int nReadCount = data[fromIndex + dataLen - 1] & 0x7F;
            OperationTag operationTag = new OperationTag();
            operationTag.setCmd(cmd);
            this.mOperateTagCount.incrementAndGet();
            boolean isEnd = this.mOperateTagCount.compareAndSet(tagCount, 0);
            operationTag.setEndTag(isEnd);
            operationTag.setTagCount(tagCount);
            operationTag.setStrPc(strPc);
            operationTag.setStrCrc(strCrc);
            operationTag.setStrEpc(strEpc);
            operationTag.setStrData(strData);
            operationTag.setDataLen(nDataLen);
            operationTag.setAntId(btAntId);
            operationTag.setReadCount(nReadCount);
            this.resultSuccess(cmd, operationTag);
        }
    }

    private void processWriteTag(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            this.resultFailure(cmd, data[fromIndex]);
        } else {
            int nEpcLen = (data[fromIndex + 2] & 0xFF) - 4;
            byte resultCode = data[fromIndex + dataLen - 3];
            if (resultCode != 16) {
                this.resultFailure(cmd, resultCode);
                return;
            }
            int tagCount = ((data[fromIndex] & 0xFF) << 8) + (data[fromIndex + 1] & 0xFF);
            int nReadCount = data[fromIndex + dataLen - 1] & 0x7F;
            String strPc = ArrayUtils.bytesToHexString(data, fromIndex + 3, 2);
            String strEpc = ArrayUtils.bytesToHexString(data, fromIndex + 5, nEpcLen);
            String strCrc = ArrayUtils.bytesToHexString(data, fromIndex + 5 + nEpcLen, 2);
            int coreDataLen = data[fromIndex + 2] & 0xFF;
            String strData = ArrayUtils.bytesToHexString(data, fromIndex + 3, coreDataLen);
            byte btTemp = data[fromIndex + dataLen - 2];
            byte btAntId = (byte)((btTemp & 3) + ((data[fromIndex + dataLen - 1] & 0xFF) >> 7) * 4 + (this.mAntennaGroupId > 0 ? 8 : 0));
            OperationTag operationTag = new OperationTag();
            operationTag.setCmd(cmd);
            this.mOperateTagCount.incrementAndGet();
            boolean isEnd = this.mOperateTagCount.compareAndSet(tagCount, 0);
            operationTag.setEndTag(isEnd);
            operationTag.setTagCount(tagCount);
            operationTag.setStrPc(strPc);
            operationTag.setStrCrc(strCrc);
            operationTag.setStrEpc(strEpc);
            operationTag.setStrData(strData);
            operationTag.setDataLen(coreDataLen);
            operationTag.setAntId(btAntId);
            operationTag.setReadCount(nReadCount);
            this.resultSuccess(cmd, operationTag);
        }
    }

    private void processLockTag(DataPacket protocol) {
        this.processWriteTag(protocol);
    }

    private void processKillTag(DataPacket protocol) {
        this.processWriteTag(protocol);
    }

    private void processSetImpinjFastTid(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processSetAndSaveImpinjFastTid(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetImpinjFastTid(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            ImpinjFastTid fastTid = new ImpinjFastTid();
            fastTid.setCmd(cmd);
            fastTid.setTidType(FastTidType.valueOf(data[fromIndex]));
            this.resultSuccess(cmd, fastTid);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processBlockTag(DataPacket protocol) {
        this.processWriteTag(protocol);
    }

    private void processSetAccessEpcMatch(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processGetAccessEpcMatch(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        byte resultCode = data[fromIndex];
        if (dataLen == 1) {
            if (resultCode == 1) {
                this.resultFailure(cmd, (byte)17);
            } else {
                this.resultFailure(cmd, resultCode);
            }
        } else if (resultCode == 0) {
            String matchEpcValue = ArrayUtils.bytesToHexString(data, fromIndex + 2, data[fromIndex + 1] & 0xFF);
            MatchInfo info = new MatchInfo();
            info.setCmd(cmd);
            info.setMatchEpcValue(matchEpcValue);
            this.resultSuccess(cmd, info);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processTagMask(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            byte resultCode = data[fromIndex];
            if (resultCode == 16) {
                Success success = new Success();
                success.setCmd(cmd);
                this.resultSuccess(cmd, success);
            } else {
                this.resultFailure(cmd, resultCode);
            }
        } else if (dataLen > 7) {
            byte btMaskId = data[fromIndex];
            byte btMaskQuantity = data[fromIndex + 1];
            byte btTarget = data[fromIndex + 2];
            byte btAction = data[fromIndex + 3];
            byte btMemBank = data[fromIndex + 4];
            byte btStartMaskAddress = data[fromIndex + 5];
            byte btMaskBitLen = data[fromIndex + 6];
            byte[] maskValue = new byte[dataLen - 8];
            for (int i = 0; i < maskValue.length; ++i) {
                maskValue[i] = data[fromIndex + 7 + i];
            }
            String strMaskValue = ArrayUtils.bytesToHexString(maskValue, 0, maskValue.length);
            byte btTruncate = data[fromIndex + dataLen - 1];
            MaskInfo info = new MaskInfo();
            info.setCmd(cmd);
            info.setMaskId(MaskId.valueOf(btMaskId));
            info.setMaskQuantity(btMaskQuantity);
            info.setMaskTarget(MaskTarget.valueOf(btTarget));
            info.setMaskAction(MaskAction.valueOf(btAction));
            info.setMemBank(MemBank.valueOf(btMemBank));
            info.setMaskBitStartAddress(btStartMaskAddress);
            info.setMaskBitLength(btMaskBitLen);
            info.setMaskValue(strMaskValue);
            info.setTruncate(btTruncate);
            this.resultSuccess(cmd, info);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processQueryReaderStatus(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            ReaderStatus readerStatus = new ReaderStatus();
            readerStatus.setCmd(cmd);
            readerStatus.setStatus(data[fromIndex]);
            this.resultSuccess(cmd, readerStatus);
        } else {
            this.resultFailure(cmd, (byte)88);
        }
    }

    private void processSetReaderStatus(DataPacket protocol) {
        this.processSet(protocol);
    }

    private void processTempLabel2Command(DataPacket protocol) {
        byte cmd = protocol.getCmd();
        int dataLen = protocol.getCoreDataLen();
        byte[] data = protocol.getData();
        int fromIndex = DataPacket.fromIndex();
        if (dataLen == 1) {
            this.resultFailure(cmd, data[fromIndex]);
            return;
        }
        int tagCount = (data[fromIndex] & 0xFF) << 8 | data[fromIndex + 1] & 0xFF;
        byte resultCode = data[fromIndex + dataLen - 3];
        int antId = data[fromIndex + dataLen - 2] & 3;
        int readCount = data[fromIndex + dataLen - 1] & 0xFF;
        int nDataLen = 0;
        String strData = "";
        switch (this.mTempLabel2Flag) {
            case 1: {
                if (resultCode != 16) break;
                nDataLen = 2;
                if (this.mTagMeasOpt == null) {
                    this.resultFailure(cmd, (byte)88);
                    return;
                }
                int value = (data[fromIndex + dataLen - 5] & 0xFF) << 8 | data[fromIndex + dataLen - 4] & 0xFF;
                if (this.mTagMeasOpt == TagMeasOpt.MeasTemp) {
                    strData = String.format(Locale.getDefault(), "%.2f", (double)value / 4.0) + " \u2103";
                    break;
                }
                strData = String.format(Locale.getDefault(), "%.2f", (double)value / 8192.0 * 2.5) + " V";
                break;
            }
            case 16: 
            case 17: {
                if (resultCode != 16) break;
                nDataLen = 2;
                break;
            }
            case 19: {
                if (resultCode != 16) break;
                nDataLen = this.mReadMemoryLen;
                break;
            }
        }
        int nEpcLen = (data[fromIndex + 2] & 0xFF) - 4 - nDataLen;
        String strPc = ArrayUtils.bytesToHexString(data, fromIndex + 3, 2);
        String strEpc = ArrayUtils.bytesToHexString(data, fromIndex + 5, nEpcLen);
        String strCrc = ArrayUtils.bytesToHexString(data, fromIndex + 5 + nEpcLen, 2);
        if (nDataLen > 0 && strData.isEmpty()) {
            strData = ArrayUtils.bytesToHexString(data, fromIndex + 7 + nEpcLen, nDataLen);
        }
        TempLabel2 label = new TempLabel2();
        label.setCmd(cmd);
        label.setType(this.mTempLabel2Flag);
        label.setResultCode(resultCode);
        label.setTagCount(tagCount);
        label.setAntId(antId);
        label.setReadCount(readCount);
        label.setStrPc(strPc);
        label.setStrEpc(strEpc);
        label.setStrCrc(strCrc);
        label.setStrData(strData);
        this.resultSuccess(cmd, label);
    }

    private void processUndefined(DataPacket protocol) {
        final ReceiveData rawData = new ReceiveData();
        rawData.setCmd(protocol.getCmd());
        int dataLen = protocol.getCoreDataLen();
        if (dataLen > 0) {
            byte[] data = new byte[dataLen];
            System.arraycopy(protocol.getData(), DataPacket.fromIndex(), data, 0, dataLen);
            rawData.setData(data);
        } else {
            rawData.setData(new byte[0]);
        }
        if (this.mUndefinedResultCallback != null) {
            if (this.mEnableAsyncCallback) {
                ThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ResultProcess.this.mUndefinedResultCallback.accept(rawData);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                try {
                    this.mUndefinedResultCallback.accept(rawData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getFreqString(int freqQuantity) {
        if (this.mIsUserDefineRegion) {
            int nExtraFrequency = freqQuantity * this.mUserDefineFreqInterval;
            float nStart = (float)(this.mUserDefineFreqStart + nExtraFrequency) / 1000.0f;
            return String.format(Locale.getDefault(), "%.3f", Float.valueOf(nStart));
        }
        if (freqQuantity < 7) {
            float nStart = 865.0f + (float)freqQuantity * 0.5f;
            return String.format(Locale.getDefault(), "%.2f", Float.valueOf(nStart));
        }
        float nStart = 902.0f + (float)(freqQuantity - 7) * 0.5f;
        return String.format(Locale.getDefault(), "%.2f", Float.valueOf(nStart));
    }

    private void resultSuccess(byte cmd, Success success) {
        Consumer onSuccess = this.mSuccessMap.get(cmd);
        if (onSuccess != null) {
            try {
                onSuccess.accept(success);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.mCmdStatusCallback != null) {
            try {
                this.mCmdStatusCallback.accept(new CmdStatus(cmd, 16, this.mAntennaId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void resultFailure(byte cmd, byte errorCode) {
        this.resultFailure(cmd, errorCode, this.mAntennaId);
    }

    private void resultFailure(byte cmd, byte errorCode, int antId) {
        Failure failure;
        if (cmd == -117 || cmd == -118 || cmd == -128) {
            if (this.mInventoryConfig != null) {
                try {
                    failure = new InventoryFailure();
                    failure.setCmd(cmd);
                    ((InventoryFailure)failure).setAntId(antId);
                    failure.setErrorCode(errorCode);
                    this.mInventoryConfig.getOnFailure().accept((InventoryFailure)failure);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            failure = new Failure();
            failure.setCmd(cmd);
            failure.setErrorCode(errorCode);
            Consumer onError = this.mFailureMap.get(cmd);
            if (onError != null) {
                try {
                    onError.accept(failure);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.mCmdStatusCallback != null) {
            try {
                this.mCmdStatusCallback.accept(new CmdStatus(cmd, errorCode, antId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void startTiming(final RequestInfo requestInfo) {
        if (this.mTimeout <= 0L) {
            return;
        }
        if (this.mScheduler == null) {
            this.mScheduler = Executors.newSingleThreadScheduledExecutor();
        }
        this.mScheduledFuture = this.mScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                if (ResultProcess.this.mTransmitWaiting.compareAndSet(true, false)) {
                    if (requestInfo != null && requestInfo.isHasResponse()) {
                        DataPacket packet = requestInfo.getDataPacket();
                        byte cmd = packet.getCmd();
                        ResultProcess.this.resultFailure(cmd, (byte)-79);
                        ResultProcess.this.checkLoopInventory(cmd, true);
                    }
                    ResultProcess.this.sendRequest();
                }
            }
        }, this.mTimeout, TimeUnit.MILLISECONDS);
    }

    private void cancelTiming() {
        if (this.mScheduledFuture != null) {
            this.mScheduledFuture.cancel(true);
            this.mScheduledFuture = null;
        }
    }

    public void setCmdStatusCallback(Consumer<CmdStatus> onStatus) {
        this.mCmdStatusCallback = onStatus;
    }

    void setOriginalDataCallback(Consumer<byte[]> onSend, Consumer<byte[]> onReceive) {
        this.mOriginalSendCallback = onSend;
        this.mOriginalReceiveCallback = onReceive;
    }

    void setUndefinedResultCallback(Consumer<ReceiveData> onResult) {
        this.mUndefinedResultCallback = onResult;
    }

    void disconnect() {
        this.stopInventory();
        this.cancelTiming();
        this.mTransmitQueue.clear();
        this.mTransmitWaiting.set(false);
        if (this.mScheduler != null) {
            this.mScheduler.shutdownNow();
            this.mScheduler = null;
        }
        if (this.mConnectHandle != null) {
            this.mConnectHandle.onDisconnect();
            this.mConnectHandle = null;
        }
    }
}

