/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.process;

import com.payne.reader.Reader;
import com.payne.reader.base.Consumer;
import com.payne.reader.bean.config.AntennaCount;
import com.payne.reader.bean.config.BaudRate;
import com.payne.reader.bean.config.Beeper;
import com.payne.reader.bean.config.ClearMaskId;
import com.payne.reader.bean.config.CmdStatus;
import com.payne.reader.bean.config.FastTidType;
import com.payne.reader.bean.config.GpioInType;
import com.payne.reader.bean.config.ProfileId;
import com.payne.reader.bean.receive.AntConnectionDetector;
import com.payne.reader.bean.receive.Failure;
import com.payne.reader.bean.receive.FreqRegionResult;
import com.payne.reader.bean.receive.GpioOut;
import com.payne.reader.bean.receive.ImpinjFastTid;
import com.payne.reader.bean.receive.MaskInfo;
import com.payne.reader.bean.receive.MatchInfo;
import com.payne.reader.bean.receive.OperationTag;
import com.payne.reader.bean.receive.OutputPower;
import com.payne.reader.bean.receive.ReaderIdentifier;
import com.payne.reader.bean.receive.ReaderStatus;
import com.payne.reader.bean.receive.ReaderTemperature;
import com.payne.reader.bean.receive.ReceiveData;
import com.payne.reader.bean.receive.RfLinkProfile;
import com.payne.reader.bean.receive.RfPortReturnLoss;
import com.payne.reader.bean.receive.Success;
import com.payne.reader.bean.receive.TempLabel2;
import com.payne.reader.bean.receive.Version;
import com.payne.reader.bean.receive.WorkAntenna;
import com.payne.reader.bean.send.CustomSessionReadConfig;
import com.payne.reader.bean.send.FreqNormal;
import com.payne.reader.bean.send.FreqUserDefine;
import com.payne.reader.bean.send.Identifier;
import com.payne.reader.bean.send.InventoryConfig;
import com.payne.reader.bean.send.KillConfig;
import com.payne.reader.bean.send.LockConfig;
import com.payne.reader.bean.send.MaskConfig;
import com.payne.reader.bean.send.MatchConfig;
import com.payne.reader.bean.send.OutputPowerConfig;
import com.payne.reader.bean.send.ReadConfig;
import com.payne.reader.bean.send.TempLabel2Config;
import com.payne.reader.bean.send.WriteConfig;
import com.payne.reader.communication.ConnectHandle;
import com.payne.reader.communication.DataPacket;
import com.payne.reader.communication.RequestInfo;
import com.payne.reader.process.ResultProcess;
import com.payne.reader.util.Converter;
import java.security.InvalidParameterException;
import java.util.Objects;

public class ReaderImpl
implements Reader {
    private final ResultProcess mResultProcess;

    private ReaderImpl(AntennaCount antennaCount) {
        this.mResultProcess = new ResultProcess(antennaCount);
    }

    public static Reader create(AntennaCount channelCount) {
        Objects.requireNonNull(channelCount);
        return new ReaderImpl(channelCount);
    }

    @Override
    public boolean connect(ConnectHandle handle) {
        return this.connect(handle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(ConnectHandle handle, boolean enableAsyncCallback) {
        boolean success;
        ReaderImpl readerImpl = this;
        synchronized (readerImpl) {
            Objects.requireNonNull(handle);
            success = this.mResultProcess.connect(handle, enableAsyncCallback);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        ReaderImpl readerImpl = this;
        synchronized (readerImpl) {
            return this.mResultProcess.isConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        ReaderImpl readerImpl = this;
        synchronized (readerImpl) {
            this.mResultProcess.disconnect();
        }
    }

    @Override
    public byte getReaderAddress() {
        return this.mResultProcess.mAddress;
    }

    @Override
    public AntennaCount getAntennaCount() {
        return this.mResultProcess.getAntennaCount();
    }

    @Override
    public void switchAntennaCount(AntennaCount antennaCount) {
        this.mResultProcess.switchAntennaCount(antennaCount);
    }

    @Override
    public void setCmdTimeout(long timeoutMillis) {
        this.mResultProcess.setTimeout(timeoutMillis);
    }

    @Override
    public void reset(Consumer<Failure> onError) {
        byte cmd = 112;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet, false);
        this.mResultProcess.setResultCallback(cmd, null, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public final void setBaudRate(BaudRate baudRate, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 113;
        byte[] btArray = new byte[]{baudRate.getValue()};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setReaderAddress(byte address, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 115;
        byte[] btArray = new byte[]{address};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getFirmwareVersion(Consumer<Version> onSuccess, Consumer<Failure> onError) {
        byte cmd = 114;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setBeeperMode(Beeper beeper, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 122;
        byte[] btArray = new byte[]{beeper.getValue()};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getReaderTemperature(Consumer<ReaderTemperature> onSuccess, Consumer<Failure> onError) {
        byte cmd = 123;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void readGpio(Consumer<GpioOut> onSuccess, Consumer<Failure> onError) {
        byte cmd = 96;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void writeGpio(GpioInType inType, boolean high, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 97;
        byte[] btArray = new byte[]{inType.getValue(), high ? (byte)1 : 0};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setAntConnectionDetector(byte detectorSensitivity, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 98;
        byte[] btArray = new byte[]{detectorSensitivity};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getAntConnectionDetector(Consumer<AntConnectionDetector> onSuccess, Consumer<Failure> onError) {
        byte cmd = 99;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setWorkAntenna(int antennaId, Consumer<Success> onSuccess, Consumer<Failure> onError) throws InvalidParameterException {
        int groupId;
        byte cmd = 116;
        byte[] btArray = new byte[1];
        int antennaCountValue = this.mResultProcess.getAntennaCount().getValue();
        if (antennaId >= antennaCountValue) {
            throw new InvalidParameterException("antennaId is greater than the number of reader channels, The current reader object is " + antennaCountValue + " channels");
        }
        if (antennaId >= 8) {
            groupId = 1;
            btArray[0] = (byte)(antennaId - 8);
        } else {
            groupId = 0;
            btArray[0] = (byte)antennaId;
        }
        this.mResultProcess.setTryAntennaId(antennaId);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        if (this.mResultProcess.getAntennaCount() == AntennaCount.SIXTEEN_CHANNELS || this.mResultProcess.getAntennaGroupId() != groupId) {
            this.mResultProcess.setAntennaGroup(groupId, requestInfo);
        } else {
            this.mResultProcess.addRequest(requestInfo);
        }
    }

    @Override
    public void getWorkAntenna(Consumer<WorkAntenna> onSuccess, Consumer<Failure> onError) {
        byte cmd = 117;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.getAntennaGroup(requestInfo);
    }

    @Override
    public int getCacheWorkAntenna() {
        return this.mResultProcess.getCacheAntennaId();
    }

    @Override
    public int getCacheAntennaGroup() {
        return this.mResultProcess.getAntennaGroupId();
    }

    @Override
    public void setOutputPower(OutputPowerConfig config, Consumer<Success> onSuccess, Consumer<Failure> onError) throws InvalidParameterException {
        byte cmd = 118;
        Objects.requireNonNull(config);
        if (!config.checkAntennaCount(this.mResultProcess.getAntennaCount())) {
            throw new InvalidParameterException("powers length is greater than the number of reader channels, The current reader object is " + this.mResultProcess.getAntennaCount().getValue() + " channels");
        }
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.setOutputPower(config);
    }

    @Override
    public void getOutputPower(Consumer<OutputPower> onSuccess, Consumer<Failure> onError) {
        byte cmd = this.mResultProcess.getAntennaCount() == AntennaCount.SIXTEEN_CHANNELS || this.mResultProcess.getAntennaCount() == AntennaCount.EIGHT_CHANNELS ? (byte)-105 : 119;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        if (this.mResultProcess.getAntennaCount() == AntennaCount.SIXTEEN_CHANNELS) {
            this.mResultProcess.setAntennaGroup(0, requestInfo);
        } else {
            this.mResultProcess.addRequest(requestInfo);
        }
    }

    @Override
    public void setOutputPowerUniformly(byte uniformPower, boolean isTemporary, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = isTemporary ? (byte)102 : 118;
        byte[] btArray = new byte[]{uniformPower};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        if (this.mResultProcess.getAntennaCount() == AntennaCount.SIXTEEN_CHANNELS) {
            this.mResultProcess.setAntennaGroup(0, requestInfo);
        } else {
            this.mResultProcess.addRequest(requestInfo);
        }
    }

    @Override
    public void setFrequencyRegion(FreqNormal freqNormal, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 120;
        Objects.requireNonNull(freqNormal);
        byte[] btArray = new byte[]{freqNormal.getRegion().getValue(), freqNormal.getFreqStart().getValue(), freqNormal.getFreqEnd().getValue()};
        this.mResultProcess.setFreqNormal();
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setUserDefineFrequency(FreqUserDefine freqUserDefine, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 120;
        Objects.requireNonNull(freqUserDefine);
        byte[] btArray = new byte[6];
        byte[] btAryFreq = Converter.getBytes(freqUserDefine.getFreqStart(), 1);
        btArray[0] = 4;
        btArray[1] = (byte)(freqUserDefine.getFreqInterval() / 10);
        btArray[2] = freqUserDefine.getFreqQuantity();
        btArray[3] = btAryFreq[2];
        btArray[4] = btAryFreq[1];
        btArray[5] = btAryFreq[0];
        this.mResultProcess.setFreqUserDefine(freqUserDefine.getFreqStart(), freqUserDefine.getFreqInterval());
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getFrequencyRegion(Consumer<FreqRegionResult> onSuccess, Consumer<Failure> onError) {
        byte cmd = 121;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setReaderIdentifier(Identifier identifier, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 103;
        byte[] identifiers = identifier.getIdentifiers();
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, identifiers);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getReaderIdentifier(Consumer<ReaderIdentifier> onSuccess, Consumer<Failure> onError) {
        byte cmd = 104;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setRfLinkProfile(ProfileId profileId, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = 105;
        byte[] btArray = new byte[]{profileId.getValue()};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getRfLinkProfile(Consumer<RfLinkProfile> onSuccess, Consumer<Failure> onError) {
        byte cmd = 106;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo config = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(config);
    }

    @Override
    public void getRfPortReturnLoss(byte frequency, Consumer<RfPortReturnLoss> onSuccess, Consumer<Failure> onError) {
        byte cmd = 126;
        byte[] btArray = new byte[]{frequency};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setInventoryConfig(InventoryConfig config) throws InvalidParameterException {
        Objects.requireNonNull(config);
        if (!config.checkAntennaCount(this.mResultProcess.getAntennaCount())) {
            throw new InvalidParameterException("The number of antennas in the fast multi-antenna inventory in the inventory configuration does not match the number of reader channels, The current reader object is " + this.mResultProcess.getAntennaCount().getValue() + " channels");
        }
        this.mResultProcess.setInventoryConfig(config);
    }

    @Override
    public void startInventory(boolean loop) {
        int interval = this.mResultProcess.mUserDefineFreqInterval;
        if (interval < 0) {
            this.getFrequencyRegion(null, null);
        }
        this.mResultProcess.startInventory(loop);
    }

    @Override
    public void stopInventory() {
        this.mResultProcess.stopInventory();
    }

    @Override
    public void readTag(ReadConfig config, Consumer<OperationTag> onSuccess, Consumer<Failure> onError) {
        byte cmd = -127;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getReadInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void readTag(CustomSessionReadConfig config, Consumer<OperationTag> onSuccess, Consumer<Failure> onError) {
        byte cmd = -127;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getReadInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void writeTag(WriteConfig config, boolean blockWrite, Consumer<OperationTag> onSuccess, Consumer<Failure> onError) {
        byte cmd = blockWrite ? (byte)-108 : -126;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getWriteInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void lockTag(LockConfig config, Consumer<OperationTag> onSuccess, Consumer<Failure> onError) {
        byte cmd = -125;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getLockInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void killTag(KillConfig config, Consumer<OperationTag> onSuccess, Consumer<Failure> onError) {
        byte cmd = -124;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getKillInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setImpinjFastTid(FastTidType fastType, boolean save, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = save ? (byte)-115 : -116;
        byte[] btArray = new byte[]{fastType.getValue()};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getImpinjFastTid(Consumer<ImpinjFastTid> onSuccess, Consumer<Failure> onError) {
        byte cmd = -114;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setEpcMatch(MatchConfig config, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = -123;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getMaskInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getEpcMatch(Consumer<MatchInfo> onSuccess, Consumer<Failure> onError) {
        byte cmd = -122;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void clearEpcMatch(Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = -123;
        byte[] btArray = new byte[]{1};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setTagMask(MaskConfig config, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = -104;
        Objects.requireNonNull(config);
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getMaskInfo());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getTagMask(Consumer<MaskInfo> onSuccess, Consumer<Failure> onError) {
        byte cmd = -104;
        byte[] btArray = new byte[]{32};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void clearTagMask(ClearMaskId function, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = -104;
        byte[] btArray = new byte[]{function.getValue()};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setReaderStatus(byte status, Consumer<Success> onSuccess, Consumer<Failure> onError) {
        byte cmd = -96;
        byte[] btArray = new byte[]{status};
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, btArray);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void getReaderStatus(Consumer<ReaderStatus> onSuccess, Consumer<Failure> onError) {
        byte cmd = -95;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd);
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void measTempLabel2(TempLabel2Config config, Consumer<TempLabel2> onSuccess, Consumer<Failure> onError) {
        byte cmd = -3;
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, config.getData());
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.setTempLabel2Config(config);
        this.mResultProcess.setResultCallback(cmd, onSuccess, onError);
        this.mResultProcess.addRequest(requestInfo);
    }

    @Override
    public void setCommandStatusCallback(Consumer<CmdStatus> onStatus) {
        this.mResultProcess.setCmdStatusCallback(onStatus);
    }

    @Override
    public void setOriginalDataCallback(Consumer<byte[]> onSend, Consumer<byte[]> onReceive) {
        this.mResultProcess.setOriginalDataCallback(onSend, onReceive);
    }

    @Override
    public void setUndefinedResultCallback(Consumer<ReceiveData> onResult) {
        this.mResultProcess.setUndefinedResultCallback(onResult);
    }

    @Override
    @Deprecated
    public void sendCustomRequest(byte cmd, byte[] data) {
        DataPacket packet = new DataPacket(this.mResultProcess.mAddress, cmd, data);
        this.sendCustomRequest(packet);
    }

    @Override
    public void sendCustomRequest(DataPacket packet) {
        RequestInfo requestInfo = new RequestInfo(packet);
        this.mResultProcess.addRequest(requestInfo);
    }
}

