/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.communication;

import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;

public class DataPacket {
    private final byte[] rawBytes;

    public DataPacket(byte address, byte cmd) {
        this(address, cmd, null);
    }

    public DataPacket(byte address, byte cmd, byte[] coreBytes) {
        this(address, cmd, coreBytes, 0, coreBytes == null ? 0 : coreBytes.length);
    }

    public DataPacket(byte address, byte cmd, byte[] data, int startIndex, int length) {
        this(-96, address, cmd, data, startIndex, length);
    }

    public DataPacket(byte head, byte address, byte cmd, byte[] data, int startIndex, int length) {
        byte checkSum;
        int btArrayLen = 0;
        if (!CheckUtils.isEmpty(data)) {
            if (length > data.length) {
                throw new InvalidParameterException("Invalid length");
            }
            if (startIndex < 0 || startIndex > length) {
                throw new InvalidParameterException("Invalid start index");
            }
            btArrayLen = length - startIndex;
        }
        byte[] sendBytes = new byte[5 + btArrayLen];
        sendBytes[0] = head;
        sendBytes[1] = (byte)(btArrayLen + 3);
        sendBytes[2] = address;
        sendBytes[3] = cmd;
        if (btArrayLen > 0) {
            System.arraycopy(data, startIndex, sendBytes, 4, btArrayLen);
        }
        sendBytes[sendBytes.length - 1] = checkSum = CheckUtils.getCheckSum(sendBytes, 0, sendBytes.length - 1);
        this.rawBytes = sendBytes;
    }

    public DataPacket(byte[] bytes) throws InvalidParameterException {
        int minProtocolDataLen = 5;
        if (bytes == null || bytes.length < minProtocolDataLen) {
            throw new InvalidParameterException("Incorrect byte array length");
        }
        this.rawBytes = bytes;
    }

    public byte getHead() {
        return this.rawBytes[0];
    }

    public byte getLen() {
        return this.rawBytes[1];
    }

    public byte getAddress() {
        return this.rawBytes[2];
    }

    public byte getCmd() {
        return this.rawBytes[3];
    }

    public int getCoreDataLen() {
        return this.rawBytes.length - 5;
    }

    public static int fromIndex() {
        return 4;
    }

    public byte getCheckSum() {
        return this.rawBytes[this.rawBytes.length - 1];
    }

    public byte[] getData() {
        return this.rawBytes;
    }

    public String toString() {
        return "DataPacket-[" + ArrayUtils.bytesToHexString(this.rawBytes, 0, this.rawBytes.length) + ']';
    }
}

