/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.MemBank;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class WriteConfig {
    private final byte[] writeInfo;

    WriteConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        int dataLen = builder.wordLength << 1;
        this.writeInfo = new byte[pwLen + 3 + dataLen];
        System.arraycopy(builder.passwords, 0, this.writeInfo, 0, pwLen);
        this.writeInfo[pwLen] = builder.memBank;
        this.writeInfo[pwLen + 1] = builder.wordStartAddress;
        this.writeInfo[pwLen + 2] = builder.wordLength;
        System.arraycopy(builder.writeData, 0, this.writeInfo, pwLen + 3, Math.min(dataLen, builder.writeData.length));
    }

    public byte[] getWriteInfo() {
        return this.writeInfo;
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte memBank = MemBank.EPC.getValue();
        private byte wordStartAddress = 0;
        private byte wordLength = 0;
        private byte[] writeData = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] password = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(password);
        }

        public Builder setMemBank(MemBank memBank) {
            Objects.requireNonNull(memBank);
            this.memBank = memBank.getValue();
            return this;
        }

        public Builder setWordStartAddress(byte wordStartAddress) {
            this.wordStartAddress = wordStartAddress;
            return this;
        }

        public Builder setWordLength(byte wordLength) {
            this.wordLength = wordLength;
            return this;
        }

        public Builder setWriteData(byte[] writeData) {
            Objects.requireNonNull(writeData);
            this.writeData = writeData;
            return this;
        }

        public Builder setWriteData(String hexData) {
            Objects.requireNonNull(hexData);
            if (CheckUtils.isNotHexString(hexData)) {
                throw new InvalidParameterException("hexData must be a hexadecimal string!");
            }
            byte[] data = ArrayUtils.hexStringToBytes(hexData);
            return this.setWriteData(data);
        }

        public WriteConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{-1, -1, -1, -1};
                this.setPasswords(passwords);
            }
            if (this.writeData == null) {
                this.writeData = new byte[this.wordLength << 1];
            } else if (this.wordLength == 0) {
                int len = this.writeData.length;
                this.wordLength = (byte)((len >>> 1) + (len & 1));
            }
            return new WriteConfig(this);
        }
    }
}

