/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.bean.config.MemBank;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class ReadConfig {
    private byte[] readInfo;

    ReadConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        this.readInfo = new byte[3 + pwLen];
        this.readInfo[0] = builder.memBank;
        this.readInfo[1] = builder.wordStartAddress;
        this.readInfo[2] = builder.wordLength;
        System.arraycopy(builder.passwords, 0, this.readInfo, 3, pwLen);
    }

    public byte[] getReadInfo() {
        return this.readInfo;
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte memBank = MemBank.EPC.getValue();
        private byte wordStartAddress = 0;
        private byte wordLength = 0;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] password = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(password);
        }

        public Builder setMemBank(MemBank memBank) {
            Objects.requireNonNull(memBank);
            this.memBank = memBank.getValue();
            return this;
        }

        public Builder setWordStartAddress(byte wordStartAddress) {
            this.wordStartAddress = wordStartAddress;
            return this;
        }

        public Builder setWordLength(byte wordLength) {
            this.wordLength = wordLength;
            return this;
        }

        public ReadConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{-1, -1, -1, -1};
                this.setPasswords(passwords);
            }
            return new ReadConfig(this);
        }
    }
}

