/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BasePower;

public class PowerSixteenAntenna
extends BasePower {
    private final byte[] powers;
    private final byte[] highEightAntennaPowers;

    PowerSixteenAntenna(byte[] powers, byte[] highEightAntennaPowers) {
        this.powers = powers;
        this.highEightAntennaPowers = highEightAntennaPowers;
    }

    @Override
    public byte[] getPowers() {
        return this.powers;
    }

    @Override
    public byte[] getHighEightAntennaPowers() {
        return this.highEightAntennaPowers;
    }

    public static class Builder {
        private byte[] powers = new byte[16];

        public Builder() {
            this.powers[0] = 33;
            this.powers[1] = 33;
            this.powers[2] = 33;
            this.powers[3] = 33;
            this.powers[4] = 33;
            this.powers[5] = 33;
            this.powers[6] = 33;
            this.powers[7] = 33;
            this.powers[8] = 33;
            this.powers[9] = 33;
            this.powers[10] = 33;
            this.powers[11] = 33;
            this.powers[12] = 33;
            this.powers[13] = 33;
            this.powers[14] = 33;
            this.powers[15] = 33;
        }

        public Builder powerA(byte power) {
            this.powers[0] = power;
            return this;
        }

        public Builder powerB(byte power) {
            this.powers[1] = power;
            return this;
        }

        public Builder powerC(byte power) {
            this.powers[2] = power;
            return this;
        }

        public Builder powerD(byte power) {
            this.powers[3] = power;
            return this;
        }

        public Builder powerE(byte power) {
            this.powers[4] = power;
            return this;
        }

        public Builder powerF(byte power) {
            this.powers[5] = power;
            return this;
        }

        public Builder powerG(byte power) {
            this.powers[6] = power;
            return this;
        }

        public Builder powerH(byte power) {
            this.powers[7] = power;
            return this;
        }

        public Builder powerI(byte power) {
            this.powers[8] = power;
            return this;
        }

        public Builder powerJ(byte power) {
            this.powers[9] = power;
            return this;
        }

        public Builder powerK(byte power) {
            this.powers[10] = power;
            return this;
        }

        public Builder powerL(byte power) {
            this.powers[11] = power;
            return this;
        }

        public Builder powerM(byte power) {
            this.powers[12] = power;
            return this;
        }

        public Builder powerN(byte power) {
            this.powers[13] = power;
            return this;
        }

        public Builder powerO(byte power) {
            this.powers[14] = power;
            return this;
        }

        public Builder powerP(byte power) {
            this.powers[15] = power;
            return this;
        }

        public Builder powers(byte[] powers) {
            if (powers == null) {
                throw new NullPointerException();
            }
            if (powers.length != this.powers.length) {
                throw new IllegalArgumentException();
            }
            this.powers = powers;
            return this;
        }

        public PowerSixteenAntenna build() {
            byte[] lowPowers = new byte[8];
            byte[] highEightAntennaPowers = new byte[8];
            System.arraycopy(this.powers, 0, lowPowers, 0, lowPowers.length);
            System.arraycopy(this.powers, lowPowers.length, highEightAntennaPowers, 0, highEightAntennaPowers.length);
            return new PowerSixteenAntenna(lowPowers, highEightAntennaPowers);
        }
    }
}

