/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BasePower;

public class PowerFourAntenna
extends BasePower {
    private final byte[] powers;

    PowerFourAntenna(byte[] powers) {
        this.powers = powers;
    }

    @Override
    public byte[] getPowers() {
        return this.powers;
    }

    @Override
    public byte[] getHighEightAntennaPowers() {
        return this.powers;
    }

    public static class Builder {
        private byte[] powers = new byte[4];

        public Builder() {
            this.powers[0] = 33;
            this.powers[1] = 33;
            this.powers[2] = 33;
            this.powers[3] = 33;
        }

        public Builder powerA(byte power) {
            this.powers[0] = power;
            return this;
        }

        public Builder powerB(byte power) {
            this.powers[1] = power;
            return this;
        }

        public Builder powerC(byte power) {
            this.powers[2] = power;
            return this;
        }

        public Builder powerD(byte power) {
            this.powers[3] = power;
            return this;
        }

        public Builder powers(byte[] powers) {
            if (powers == null) {
                throw new NullPointerException();
            }
            if (powers.length != this.powers.length) {
                throw new IllegalArgumentException();
            }
            this.powers = powers;
            return this;
        }

        public PowerFourAntenna build() {
            return new PowerFourAntenna(this.powers);
        }
    }
}

