/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BasePower;

public class PowerEightAntenna
extends BasePower {
    private final byte[] powers;

    PowerEightAntenna(byte[] powers) {
        this.powers = powers;
    }

    @Override
    public byte[] getPowers() {
        return this.powers;
    }

    @Override
    public byte[] getHighEightAntennaPowers() {
        return this.powers;
    }

    public static class Builder {
        private byte[] powers = new byte[8];

        public Builder() {
            this.powers[0] = 33;
            this.powers[1] = 33;
            this.powers[2] = 33;
            this.powers[3] = 33;
            this.powers[4] = 33;
            this.powers[5] = 33;
            this.powers[6] = 33;
            this.powers[7] = 33;
        }

        public Builder powerA(byte power) {
            this.powers[0] = power;
            return this;
        }

        public Builder powerB(byte power) {
            this.powers[1] = power;
            return this;
        }

        public Builder powerC(byte power) {
            this.powers[2] = power;
            return this;
        }

        public Builder powerD(byte power) {
            this.powers[3] = power;
            return this;
        }

        public Builder powerE(byte power) {
            this.powers[4] = power;
            return this;
        }

        public Builder powerF(byte power) {
            this.powers[5] = power;
            return this;
        }

        public Builder powerG(byte power) {
            this.powers[6] = power;
            return this;
        }

        public Builder powerH(byte power) {
            this.powers[7] = power;
            return this;
        }

        public Builder powers(byte[] powers) {
            if (powers == null) {
                throw new NullPointerException();
            }
            if (powers.length != this.powers.length) {
                throw new IllegalArgumentException();
            }
            this.powers = powers;
            return this;
        }

        public PowerEightAntenna build() {
            return new PowerEightAntenna(this.powers);
        }
    }
}

