/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.BasePower;
import com.payne.reader.bean.config.AntennaCount;
import com.payne.reader.bean.send.PowerEightAntenna;
import com.payne.reader.bean.send.PowerFourAntenna;
import com.payne.reader.bean.send.PowerSingleAntenna;
import com.payne.reader.bean.send.PowerSixteenAntenna;
import java.util.Objects;

public class OutputPowerConfig {
    private byte[] powers;
    private byte[] highEightAntennaPowers;
    private AntennaCount antennaCount;

    private OutputPowerConfig() {
    }

    public byte[] getPowers() {
        return this.powers;
    }

    public byte[] getHighEightAntennaPowers() {
        return this.highEightAntennaPowers;
    }

    public boolean checkAntennaCount(AntennaCount count) {
        return this.antennaCount == count;
    }

    public static OutputPowerConfig outputPower(PowerSingleAntenna power) {
        return OutputPowerConfig.configPowers(power, AntennaCount.SINGLE_CHANNEL);
    }

    public static OutputPowerConfig outputPower(PowerFourAntenna power) {
        return OutputPowerConfig.configPowers(power, AntennaCount.FOUR_CHANNELS);
    }

    public static OutputPowerConfig outputPower(PowerEightAntenna power) {
        return OutputPowerConfig.configPowers(power, AntennaCount.EIGHT_CHANNELS);
    }

    public static OutputPowerConfig outputPower(PowerSixteenAntenna power) {
        return OutputPowerConfig.configPowers(power, AntennaCount.SIXTEEN_CHANNELS);
    }

    private static OutputPowerConfig configPowers(BasePower power, AntennaCount antennaCount) {
        Objects.requireNonNull(power);
        OutputPowerConfig config = new OutputPowerConfig();
        config.powers = power.getPowers();
        config.highEightAntennaPowers = power.getHighEightAntennaPowers();
        config.antennaCount = antennaCount;
        return config;
    }
}

