/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.TempLabel2Info;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public class MtWriteMemory
implements TempLabel2Info {
    private final byte[] info;

    MtWriteMemory(Builder builder) {
        int pwLen = builder.passwords.length;
        int authPwdLen = builder.authPwd.length;
        int dataLen = builder.data.length;
        this.info = new byte[pwLen + authPwdLen + dataLen + 8];
        this.info[0] = 20;
        System.arraycopy(builder.passwords, 0, this.info, 1, pwLen);
        this.info[pwLen + 1] = (byte)(builder.tLoggerOpt2 >> 24);
        this.info[pwLen + 2] = (byte)(builder.tLoggerOpt2 >> 16);
        this.info[pwLen + 3] = (byte)(builder.tLoggerOpt2 >> 8);
        this.info[pwLen + 4] = (byte)builder.tLoggerOpt2;
        System.arraycopy(builder.authPwd, 0, this.info, pwLen + 5, authPwdLen);
        this.info[pwLen + authPwdLen + 5] = (byte)(builder.startAddress >> 8);
        this.info[pwLen + authPwdLen + 6] = (byte)builder.startAddress;
        this.info[pwLen + authPwdLen + 7] = builder.count;
        System.arraycopy(builder.data, 0, this.info, pwLen + authPwdLen + 8, dataLen);
    }

    @Override
    public byte[] getTempLabel2Info() {
        return this.info;
    }

    public static class Builder {
        private byte[] passwords = null;
        private int tLoggerOpt2 = 0;
        private byte[] authPwd = null;
        private short startAddress = 0;
        private byte count = (byte)4;
        private byte[] data = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] identifiers = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(identifiers);
        }

        public Builder setSecretKeyType(byte secretKeyType) {
            this.tLoggerOpt2 &= secretKeyType << 16 | 0xFFF8FFFF;
            return this;
        }

        public Builder setAuthPwd(byte[] authPwd) {
            Objects.requireNonNull(authPwd);
            int demandLength = 4;
            if (authPwd.length < demandLength) {
                byte[] src = authPwd;
                authPwd = new byte[demandLength];
                System.arraycopy(src, 0, authPwd, 0, src.length);
            } else if (authPwd.length > demandLength) {
                byte[] src = authPwd;
                authPwd = new byte[demandLength];
                System.arraycopy(src, 0, authPwd, 0, authPwd.length);
            }
            this.authPwd = authPwd;
            return this;
        }

        public Builder setAuthPwd(String hexAuthPwd) {
            Objects.requireNonNull(hexAuthPwd);
            if (CheckUtils.isNotHexString(hexAuthPwd)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] passwords = ArrayUtils.hexStringToBytes(hexAuthPwd);
            return this.setAuthPwd(passwords);
        }

        public Builder setStartAddress(short startAddress) {
            this.startAddress = startAddress;
            return this;
        }

        public Builder setCount(byte count) {
            this.count = count;
            return this;
        }

        public Builder setData(byte[] data) {
            this.data = data;
            return this;
        }

        public MtWriteMemory build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{0, 0, 0, 0};
                this.setPasswords(passwords);
            }
            if (this.authPwd == null) {
                byte[] authPwd = new byte[]{0, 0, 0, 0};
                this.setAuthPwd(authPwd);
            }
            if (this.data == null) {
                byte[] btData = new byte[]{0, 0, 0, 0};
                this.setData(btData);
            }
            return new MtWriteMemory(this);
        }
    }
}

