/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.TempLabel2Info;
import com.payne.reader.bean.config.TagMeasOpt;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public class MtSingleMeasTemp
implements TempLabel2Info {
    private final byte[] info;

    MtSingleMeasTemp(Builder builder) {
        int pwLen = builder.passwords.length;
        int measLen = builder.tagMeasOpt.length;
        this.info = new byte[pwLen + measLen + 1];
        this.info[0] = 1;
        System.arraycopy(builder.passwords, 0, this.info, 1, pwLen);
        System.arraycopy(builder.tagMeasOpt, 0, this.info, 1 + pwLen, measLen);
    }

    @Override
    public byte[] getTempLabel2Info() {
        return this.info;
    }

    public TagMeasOpt getTagMeasOpt() {
        int startIndex = this.info.length - 4;
        int value = ArrayUtils.byteArrayToInt(this.info, startIndex, 4);
        return TagMeasOpt.valueOf(value);
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte[] tagMeasOpt = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] identifiers = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(identifiers);
        }

        public Builder setTagMeasOpt(byte[] tagMeasOpt) {
            Objects.requireNonNull(tagMeasOpt);
            int demandLength = 4;
            if (tagMeasOpt.length < demandLength) {
                byte[] src = tagMeasOpt;
                tagMeasOpt = new byte[demandLength];
                System.arraycopy(src, 0, tagMeasOpt, 0, src.length);
            } else if (tagMeasOpt.length > demandLength) {
                byte[] src = tagMeasOpt;
                tagMeasOpt = new byte[demandLength];
                System.arraycopy(src, 0, tagMeasOpt, 0, tagMeasOpt.length);
            }
            this.tagMeasOpt = tagMeasOpt;
            return this;
        }

        public Builder setTagMeasOpt(TagMeasOpt opt) {
            Objects.requireNonNull(opt);
            return this.setTagMeasOpt(ArrayUtils.intToByteArray(opt.getValue()));
        }

        public MtSingleMeasTemp build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{0, 0, 0, 0};
                this.setPasswords(passwords);
            }
            if (this.tagMeasOpt == null) {
                this.setTagMeasOpt(TagMeasOpt.MeasTemp);
            }
            return new MtSingleMeasTemp(this);
        }
    }
}

