/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.TempLabel2Info;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public class MtReadRegister
implements TempLabel2Info {
    private final byte[] info;

    MtReadRegister(Builder builder) {
        int pwLen = builder.passwords.length;
        int measLen = builder.ptr.length;
        this.info = new byte[pwLen + measLen + 1];
        this.info[0] = 16;
        System.arraycopy(builder.passwords, 0, this.info, 1, pwLen);
        System.arraycopy(builder.ptr, 0, this.info, 1 + pwLen, measLen);
    }

    @Override
    public byte[] getTempLabel2Info() {
        return this.info;
    }

    public static class Builder {
        private byte[] passwords = null;
        private byte[] ptr = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] passwords = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(passwords);
        }

        public Builder setPtr(byte[] ptr) {
            Objects.requireNonNull(ptr);
            int demandLength = 4;
            if (ptr.length < demandLength) {
                byte[] src = ptr;
                ptr = new byte[demandLength];
                System.arraycopy(src, 0, ptr, 0, src.length);
            } else if (ptr.length > demandLength) {
                byte[] src = ptr;
                ptr = new byte[demandLength];
                System.arraycopy(src, 0, ptr, 0, ptr.length);
            }
            this.ptr = ptr;
            return this;
        }

        public Builder setPtr(int ptr) {
            byte[] btPtr = ArrayUtils.intToByteArray(ptr);
            return this.setPtr(btPtr);
        }

        public Builder setPtr(String hexPtr) {
            Objects.requireNonNull(hexPtr);
            if (CheckUtils.isNotHexString(hexPtr)) {
                throw new InvalidParameterException("hexPtr must be a hexadecimal string!");
            }
            byte[] ptr = ArrayUtils.hexStringToBytes(hexPtr);
            return this.setPtr(ptr);
        }

        public MtReadRegister build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{0, 0, 0, 0};
                this.setPasswords(passwords);
            }
            if (this.ptr == null) {
                byte[] btPtr = new byte[]{0, 0, 0, 0};
                this.setPtr(btPtr);
            }
            return new MtReadRegister(this);
        }
    }
}

