/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.TempLabel2Info;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public class MtLoadConfig
implements TempLabel2Info {
    private final byte[] info;

    MtLoadConfig(Builder builder) {
        int pwLen = builder.passwords.length;
        this.info = new byte[pwLen + 1];
        this.info[0] = 4;
        System.arraycopy(builder.passwords, 0, this.info, 1, pwLen);
    }

    @Override
    public byte[] getTempLabel2Info() {
        return this.info;
    }

    public static class Builder {
        private byte[] passwords = null;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] identifiers = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(identifiers);
        }

        public MtLoadConfig build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{0, 0, 0, 0};
                this.setPasswords(passwords);
            }
            return new MtLoadConfig(this);
        }
    }
}

