/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.base.TempLabel2Info;
import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public class MtLedControl
implements TempLabel2Info {
    private final byte[] info;

    MtLedControl(Builder builder) {
        int pwLen = builder.passwords.length;
        this.info = new byte[pwLen + 5];
        this.info[0] = 32;
        System.arraycopy(builder.passwords, 0, this.info, 1, pwLen);
        this.info[pwLen + 1] = (byte)(builder.tLoggerOpt2 >> 24);
        this.info[pwLen + 2] = (byte)(builder.tLoggerOpt2 >> 16);
        this.info[pwLen + 3] = (byte)(builder.tLoggerOpt2 >> 8);
        this.info[pwLen + 4] = (byte)builder.tLoggerOpt2;
    }

    @Override
    public byte[] getTempLabel2Info() {
        return this.info;
    }

    public static class Builder {
        private byte[] passwords = null;
        private int tLoggerOpt2 = 0;

        public Builder setPasswords(byte[] passwords) {
            Objects.requireNonNull(passwords);
            int demandLength = 4;
            if (passwords.length < demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, src.length);
                for (int i = src.length; i < passwords.length; ++i) {
                    passwords[i] = -1;
                }
            } else if (passwords.length > demandLength) {
                byte[] src = passwords;
                passwords = new byte[demandLength];
                System.arraycopy(src, 0, passwords, 0, passwords.length);
            }
            this.passwords = passwords;
            return this;
        }

        public Builder setPasswords(String hexPassword) {
            Objects.requireNonNull(hexPassword);
            if (CheckUtils.isNotHexString(hexPassword)) {
                throw new InvalidParameterException("hexPassword must be a hexadecimal string!");
            }
            byte[] passwords = ArrayUtils.hexStringToBytes(hexPassword);
            return this.setPasswords(passwords);
        }

        public Builder setBright(boolean enable) {
            this.tLoggerOpt2 = enable ? 524288 : 0;
            return this;
        }

        public MtLedControl build() {
            if (this.passwords == null) {
                byte[] passwords = new byte[]{0, 0, 0, 0};
                this.setPasswords(passwords);
            }
            return new MtLedControl(this);
        }
    }
}

