/*
 * Decompiled with CFR 0.152.
 */
package com.payne.reader.bean.send;

import com.payne.reader.util.ArrayUtils;
import com.payne.reader.util.CheckUtils;
import java.security.InvalidParameterException;
import java.util.Objects;

public final class MatchConfig {
    private byte[] maskInfo;

    MatchConfig(Builder builder) {
        int valueLen = builder.epcValues.length;
        this.maskInfo = new byte[2 + valueLen];
        this.maskInfo[0] = builder.mode;
        this.maskInfo[1] = builder.epcLength;
        System.arraycopy(builder.epcValues, 0, this.maskInfo, 2, valueLen);
    }

    public byte[] getMaskInfo() {
        return this.maskInfo;
    }

    public static class Builder {
        private byte mode = 0;
        private byte epcLength = 0;
        private byte[] epcValues = null;

        public Builder setMaskValue(byte[] epcValues) {
            Objects.requireNonNull(epcValues);
            this.epcValues = epcValues;
            this.epcLength = (byte)epcValues.length;
            return this;
        }

        public Builder setMaskValue(String hexEpcValues) {
            Objects.requireNonNull(hexEpcValues);
            if (CheckUtils.isNotHexString(hexEpcValues)) {
                throw new InvalidParameterException("hexEpcValues must be a hexadecimal string!");
            }
            byte[] data = ArrayUtils.hexStringToBytes(hexEpcValues);
            return this.setMaskValue(data);
        }

        public MatchConfig build() {
            if (this.epcValues == null) {
                this.epcValues = new byte[this.epcLength & 0xFF];
            }
            return new MatchConfig(this);
        }
    }
}

